"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCacheErrors = useCacheErrors;
exports.toArray = toArray;
exports.getFieldId = getFieldId;
exports.useForm = useForm;

var React = _interopRequireWildcard(require("react"));

var _rcFieldForm = require("rc-field-form");

var _domScrollIntoView = _interopRequireDefault(require("dom-scroll-into-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * We will remove light way shake like:
 * errors -> none -> errors (in 100 ms)
 * to
 * errors (in 100 ms)
 */
function useDebounce(content) {
  var delay = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 10;

  var _React$useState = React.useState(content),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      cache = _React$useState2[0],
      setCache = _React$useState2[1]; // React hooks still have bug with unmount setState
  // https://github.com/facebook/react/issues/15057


  React.useEffect(function () {
    if (content.length) {
      setCache(content);
    } else {
      var timeout = setTimeout(function () {
        setCache(content);
      }, delay);
      return function () {
        clearTimeout(timeout);
      };
    }
  }, [content]);
  return cache;
}
/**
 * Cache latest errors and trigger change event if visible change
 */


function useCacheErrors(errors, changeTrigger) {
  var debounceErrors = useDebounce(errors);

  var _React$useState3 = React.useState(debounceErrors),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      cacheErrors = _React$useState4[0],
      setCacheErrors = _React$useState4[1];

  var _React$useState5 = React.useState(false),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      visible = _React$useState6[0],
      setVisible = _React$useState6[1];

  React.useEffect(function () {
    var newVisible = !!debounceErrors.length;

    if (debounceErrors.length) {
      setCacheErrors(debounceErrors);
    }

    if (newVisible !== visible) {
      changeTrigger(newVisible);
    }

    setVisible(newVisible);
  }, [debounceErrors]);
  return [visible, cacheErrors];
}

function toArray(candidate) {
  if (candidate === undefined || candidate === false) return [];
  return Array.isArray(candidate) ? candidate : [candidate];
}

function getFieldId(namePath, formName) {
  if (!namePath.length) return undefined;
  var mergedId = namePath.join('_');
  return formName ? "".concat(formName, "_").concat(mergedId) : mergedId;
} // Source: https://github.com/react-component/form/blob/master/src/createDOMForm.js


function getScrollableContainer(current) {
  var node = current;
  var nodeName;
  /* eslint no-cond-assign:0 */

  while (node && (nodeName = node.nodeName.toLowerCase()) !== 'body') {
    var _getComputedStyle = getComputedStyle(node),
        overflowY = _getComputedStyle.overflowY; // https://stackoverflow.com/a/36900407/3040605


    if (node !== current && (overflowY === 'auto' || overflowY === 'scroll') && node.scrollHeight > node.clientHeight) {
      return node;
    }

    node = node.parentElement;
  }

  return nodeName === 'body' ? node.ownerDocument : node;
}

function useForm(form) {
  var wrapForm = form || _extends(_extends({}, (0, _rcFieldForm.useForm)()[0]), {
    __INTERNAL__: {},
    scrollToField: function scrollToField(name) {
      var namePath = toArray(name);
      var fieldId = getFieldId(namePath, wrapForm.__INTERNAL__.name);
      var node = fieldId ? document.getElementById(fieldId) : null;

      if (node) {
        (0, _domScrollIntoView["default"])(node, getScrollableContainer(node), {
          onlyScrollIfNeeded: true
        });
      }
    }
  });

  return [wrapForm];
}
//# sourceMappingURL=util.js.map
