"use strict";

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = useSelection;
exports.SELECTION_INVERT = exports.SELECTION_ALL = void 0;

var React = _interopRequireWildcard(require("react"));

var _icons = require("@ant-design/icons");

var _checkbox = _interopRequireDefault(require("../../checkbox"));

var _dropdown = _interopRequireDefault(require("../../dropdown"));

var _menu = _interopRequireDefault(require("../../menu"));

var _radio = _interopRequireDefault(require("../../radio"));

var _warning = _interopRequireDefault(require("../../_util/warning"));

var _configProvider = require("../../config-provider");

var _en_US = _interopRequireDefault(require("../../locale/en_US"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _nonIterableRest(); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

var EMPTY_LIST = []; // TODO: warning if use ajax!!!

var SELECTION_ALL = 'SELECT_ALL';
exports.SELECTION_ALL = SELECTION_ALL;
var SELECTION_INVERT = 'SELECT_INVERT';
exports.SELECTION_INVERT = SELECTION_INVERT;

function getFixedType(column) {
  return column && column.fixed;
}

function flattenData(data, childrenColumnName) {
  var list = [];
  (data || []).forEach(function (record) {
    list.push(record);

    if (childrenColumnName in record) {
      list = [].concat(_toConsumableArray(list), _toConsumableArray(flattenData(record[childrenColumnName], childrenColumnName)));
    }
  });
  return list;
}

function useSelection(rowSelection, config) {
  var _ref = rowSelection || {},
      selectedRowKeys = _ref.selectedRowKeys,
      getCheckboxProps = _ref.getCheckboxProps,
      onSelectionChange = _ref.onChange,
      onSelect = _ref.onSelect,
      onSelectAll = _ref.onSelectAll,
      onSelectInvert = _ref.onSelectInvert,
      onSelectMultiple = _ref.onSelectMultiple,
      _ref$columnWidth = _ref.columnWidth,
      selectionColWidth = _ref$columnWidth === void 0 ? 60 : _ref$columnWidth,
      selectionType = _ref.type,
      selections = _ref.selections;

  var _React$useContext = React.useContext(_configProvider.ConfigContext),
      _React$useContext$loc = _React$useContext.locale,
      locale = _React$useContext$loc === void 0 ? _en_US["default"] : _React$useContext$loc;

  var tableLocale = locale.Table || {};
  var prefixCls = config.prefixCls,
      data = config.data,
      pageData = config.pageData,
      getRecordByKey = config.getRecordByKey,
      getRowKey = config.getRowKey,
      expandType = config.expandType,
      childrenColumnName = config.childrenColumnName;

  var _React$useState = React.useState(),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      innerSelectedKeys = _React$useState2[0],
      setInnerSelectedKeys = _React$useState2[1];

  var mergedSelectedKeys = selectedRowKeys || innerSelectedKeys || EMPTY_LIST;
  var mergedSelectedKeySet = React.useMemo(function () {
    var keys = selectionType === 'radio' ? mergedSelectedKeys.slice(0, 1) : mergedSelectedKeys;
    return new Set(keys);
  }, [mergedSelectedKeys, selectionType]); // Save last selected key to enable range selection

  var _React$useState3 = React.useState(null),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      lastSelectedKey = _React$useState4[0],
      setLastSelectedKey = _React$useState4[1]; // Reset if rowSelection reset


  React.useEffect(function () {
    if (!rowSelection) {
      setInnerSelectedKeys([]);
    }
  }, [!!rowSelection]);
  var setSelectedKeys = React.useCallback(function (keys) {
    setInnerSelectedKeys(keys);
    var records = keys.map(function (key) {
      return getRecordByKey(key);
    });

    if (onSelectionChange) {
      onSelectionChange(keys, records);
    }
  }, [setInnerSelectedKeys, getRecordByKey, onSelectionChange]); // Trigger single `onSelect` event

  var triggerSingleSelection = React.useCallback(function (key, selected, keys, event) {
    if (onSelect) {
      var rows = keys.map(function (k) {
        return getRecordByKey(k);
      });
      onSelect(getRecordByKey(key), selected, rows, event);
    }

    setSelectedKeys(keys);
  }, [onSelect, getRecordByKey, setSelectedKeys]);
  var mergedSelections = React.useMemo(function () {
    if (!selections) {
      return null;
    }

    var selectionList = selections === true ? [SELECTION_ALL, SELECTION_INVERT] : selections;
    return selectionList.map(function (selection) {
      if (selection === SELECTION_ALL) {
        return {
          key: 'all',
          text: tableLocale.selectionAll,
          onSelect: function onSelect() {
            setSelectedKeys(data.map(function (record, index) {
              return getRowKey(record, index);
            }));
          }
        };
      }

      if (selection === SELECTION_INVERT) {
        return {
          key: 'invert',
          text: tableLocale.selectInvert,
          onSelect: function onSelect() {
            var keySet = new Set(mergedSelectedKeySet);
            pageData.forEach(function (record, index) {
              var key = getRowKey(record, index);

              if (keySet.has(key)) {
                keySet["delete"](key);
              } else {
                keySet.add(key);
              }
            });
            var keys = Array.from(keySet);
            setSelectedKeys(keys);

            if (onSelectInvert) {
              (0, _warning["default"])(false, 'Table', '`onSelectInvert` will be removed in future. Please use `onChange` instead.');
              onSelectInvert(keys);
            }
          }
        };
      }

      return selection;
    });
  }, [selections, mergedSelectedKeySet, pageData, getRowKey]);
  var transformColumns = React.useCallback(function (columns) {
    if (!rowSelection) {
      return columns;
    } // Get flatten data


    var flattedData = flattenData(pageData, childrenColumnName); // Support selection

    var keySet = new Set(mergedSelectedKeySet); // Get all checkbox props

    var checkboxPropsMap = new Map();
    flattedData.forEach(function (record, index) {
      var key = getRowKey(record, index);
      var checkboxProps = (getCheckboxProps ? getCheckboxProps(record) : null) || {};
      checkboxPropsMap.set(key, checkboxProps);

      if (process.env.NODE_ENV !== 'production' && ('checked' in checkboxProps || 'defaultChecked' in checkboxProps)) {
        (0, _warning["default"])(false, 'Table', 'Do not set `checked` or `defaultChecked` in `getCheckboxProps`. Please use `selectedRowKeys` instead.');
      }
    }); // Record key only need check with enabled

    var recordKeys = flattedData.map(getRowKey).filter(function (key) {
      return !checkboxPropsMap.get(key).disabled;
    });
    var checkedCurrentAll = recordKeys.every(function (key) {
      return keySet.has(key);
    });
    var checkedCurrentSome = recordKeys.some(function (key) {
      return keySet.has(key);
    });

    var onSelectAllChange = function onSelectAllChange() {
      var changeKeys = [];

      if (checkedCurrentAll) {
        recordKeys.forEach(function (key) {
          keySet["delete"](key);
          changeKeys.push(key);
        });
      } else {
        recordKeys.forEach(function (key) {
          keySet.add(key);
          changeKeys.push(key);
        });
      }

      var keys = Array.from(keySet);
      setSelectedKeys(keys);

      if (onSelectAll) {
        onSelectAll(!checkedCurrentAll, keys.map(function (k) {
          return getRecordByKey(k);
        }), changeKeys.map(function (k) {
          return getRecordByKey(k);
        }));
      }
    }; // ===================== Render =====================
    // Title Cell


    var title;

    if (selectionType !== 'radio') {
      var customizeSelections;

      if (mergedSelections) {
        var menu = React.createElement(_menu["default"], null, mergedSelections.map(function (selection, index) {
          var key = selection.key,
              text = selection.text,
              onSelectionClick = selection.onSelect;
          return React.createElement(_menu["default"].Item, {
            key: key || index,
            onClick: function onClick() {
              if (onSelectionClick) {
                onSelectionClick(recordKeys);
              }
            }
          }, text);
        }));
        customizeSelections = React.createElement("div", {
          className: "".concat(prefixCls, "-selection-extra")
        }, React.createElement(_dropdown["default"], {
          overlay: menu
        }, React.createElement("span", null, React.createElement(_icons.DownOutlined, null))));
      }

      title = React.createElement("div", {
        className: "".concat(prefixCls, "-selection")
      }, React.createElement(_checkbox["default"], {
        checked: !!flattedData.length && checkedCurrentAll,
        indeterminate: !checkedCurrentAll && checkedCurrentSome,
        onChange: onSelectAllChange,
        disabled: flattedData.length === 0 || flattedData.every(function (record, index) {
          var key = getRowKey(record, index);
          var checkboxProps = checkboxPropsMap.get(key) || {};
          return checkboxProps.disabled;
        })
      }), customizeSelections);
    } // Body Cell


    var renderCell;

    if (selectionType === 'radio') {
      renderCell = function renderCell(_, record, index) {
        var key = getRowKey(record, index);
        return React.createElement(_radio["default"], _extends({}, checkboxPropsMap.get(key), {
          checked: keySet.has(key),
          onChange: function onChange(event) {
            if (!keySet.has(key)) {
              triggerSingleSelection(key, true, [key], event.nativeEvent);
            }
          }
        }));
      };
    } else {
      renderCell = function renderCell(_, record, index) {
        var key = getRowKey(record, index);
        var hasKey = keySet.has(key); // Record checked

        return React.createElement(_checkbox["default"], _extends({}, checkboxPropsMap.get(key), {
          checked: hasKey,
          onChange: function onChange(_ref2) {
            var nativeEvent = _ref2.nativeEvent;
            var shiftKey = nativeEvent.shiftKey;
            var startIndex = -1;
            var endIndex = -1; // Get range of this

            if (shiftKey) {
              var pointKeys = new Set([lastSelectedKey, key]);
              recordKeys.some(function (recordKey, recordIndex) {
                if (pointKeys.has(recordKey)) {
                  if (startIndex === -1) {
                    startIndex = recordIndex;
                  } else {
                    endIndex = recordIndex;
                    return true;
                  }
                }

                return false;
              });
            }

            if (endIndex !== -1 && startIndex !== endIndex) {
              // Batch update selections
              var rangeKeys = recordKeys.slice(startIndex, endIndex + 1);
              var changedKeys = [];

              if (hasKey) {
                rangeKeys.forEach(function (recordKey) {
                  if (keySet.has(recordKey)) {
                    changedKeys.push(recordKey);
                    keySet["delete"](recordKey);
                  }
                });
              } else {
                rangeKeys.forEach(function (recordKey) {
                  if (!keySet.has(recordKey)) {
                    changedKeys.push(recordKey);
                    keySet.add(recordKey);
                  }
                });
              }

              var keys = Array.from(keySet);
              setSelectedKeys(keys);

              if (onSelectMultiple) {
                onSelectMultiple(!hasKey, keys.map(function (recordKey) {
                  return getRecordByKey(recordKey);
                }), changedKeys.map(function (recordKey) {
                  return getRecordByKey(recordKey);
                }));
              }
            } else {
              // Single record selected
              if (hasKey) {
                keySet["delete"](key);
              } else {
                keySet.add(key);
              }

              triggerSingleSelection(key, !hasKey, Array.from(keySet), nativeEvent);
            }

            setLastSelectedKey(key);
          }
        }));
      };
    } // Columns


    var selectionColumn = {
      width: selectionColWidth,
      className: "".concat(prefixCls, "-selection-column"),
      title: rowSelection.columnTitle || title,
      render: renderCell
    };

    if (expandType === 'row' && columns.length) {
      var _columns = _toArray(columns),
          expandColumn = _columns[0],
          restColumns = _columns.slice(1);

      return [expandColumn, _extends(_extends({}, selectionColumn), {
        fixed: getFixedType(restColumns[0])
      })].concat(_toConsumableArray(restColumns));
    }

    return [_extends(_extends({}, selectionColumn), {
      fixed: getFixedType(columns[0])
    })].concat(_toConsumableArray(columns));
  }, [getRowKey, pageData, rowSelection, innerSelectedKeys, mergedSelectedKeys, selectionColWidth, mergedSelections, expandType, lastSelectedKey, onSelectMultiple, triggerSingleSelection]);
  return [transformColumns, mergedSelectedKeySet];
}
//# sourceMappingURL=useSelection.js.map
