import * as React from 'react';
import CheckableTag from './CheckableTag';
import { ConfigConsumerProps } from '../config-provider';
export { CheckableTagProps } from './CheckableTag';
export interface TagProps extends React.HTMLAttributes<HTMLSpanElement> {
    prefixCls?: string;
    className?: string;
    color?: string;
    closable?: boolean;
    visible?: boolean;
    onClose?: Function;
    style?: React.CSSProperties;
}
interface TagState {
    visible: boolean;
}
declare class Tag extends React.Component<TagProps, TagState> {
    static CheckableTag: typeof CheckableTag;
    static defaultProps: {
        closable: boolean;
    };
    static getDerivedStateFromProps(nextProps: TagProps): {
        visible: boolean | undefined;
    } | null;
    state: {
        visible: boolean;
    };
    getTagStyle(): {
        backgroundColor: string | undefined;
    } | {
        alignContent?: string | undefined;
        alignItems?: string | undefined;
        alignSelf?: string | undefined;
        animationDelay?: string | undefined;
        animationDirection?: string | undefined;
        animationDuration?: string | undefined;
        animationFillMode?: string | undefined;
        animationIterationCount?: string | number | undefined;
        animationName?: string | undefined;
        animationPlayState?: string | undefined;
        animationTimingFunction?: string | undefined;
        appearance?: "button" | "meter" | "textarea" | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "button-bevel" | "checkbox" | "listbox" | "menulist" | "menulist-button" | "progress-bar" | "push-button" | "radio" | "searchfield" | "slider-horizontal" | "square-button" | "textfield" | undefined;
        backdropFilter?: string | undefined;
        backfaceVisibility?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "hidden" | "visible" | undefined;
        backgroundAttachment?: string | undefined;
        backgroundBlendMode?: string | undefined;
        backgroundClip?: string | undefined;
        backgroundColor: string | undefined;
        backgroundImage?: string | undefined;
        backgroundOrigin?: string | undefined;
        backgroundPosition?: string | number | undefined;
        backgroundPositionX?: string | number | undefined;
        backgroundPositionY?: string | number | undefined;
        backgroundRepeat?: string | undefined;
        backgroundSize?: string | number | undefined;
        blockOverflow?: string | undefined;
        blockSize?: string | number | undefined;
        borderBlockColor?: string | undefined;
        borderBlockEndColor?: string | undefined;
        borderBlockEndStyle?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "hidden" | "dashed" | "dotted" | "double" | "groove" | "inset" | "outset" | "ridge" | "solid" | undefined;
        borderBlockEndWidth?: string | number | undefined;
        borderBlockStartColor?: string | undefined;
        borderBlockStartStyle?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "hidden" | "dashed" | "dotted" | "double" | "groove" | "inset" | "outset" | "ridge" | "solid" | undefined;
        borderBlockStartWidth?: string | number | undefined;
        borderBlockStyle?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "hidden" | "dashed" | "dotted" | "double" | "groove" | "inset" | "outset" | "ridge" | "solid" | undefined;
        borderBlockWidth?: string | number | undefined;
        borderBottomColor?: string | undefined;
        borderBottomLeftRadius?: string | number | undefined;
        borderBottomRightRadius?: string | number | undefined;
        borderBottomStyle?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "hidden" | "dashed" | "dotted" | "double" | "groove" | "inset" | "outset" | "ridge" | "solid" | undefined;
        borderBottomWidth?: string | number | undefined;
        borderCollapse?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "collapse" | "separate" | undefined;
        borderEndEndRadius?: string | number | undefined;
        borderEndStartRadius?: string | number | undefined;
        borderImageOutset?: string | number | undefined;
        borderImageRepeat?: string | undefined;
        borderImageSlice?: string | number | undefined;
        borderImageSource?: string | undefined;
        borderImageWidth?: string | number | undefined;
        borderInlineColor?: string | undefined;
        borderInlineEndColor?: string | undefined;
        borderInlineEndStyle?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "hidden" | "dashed" | "dotted" | "double" | "groove" | "inset" | "outset" | "ridge" | "solid" | undefined;
        borderInlineEndWidth?: string | number | undefined;
        borderInlineStartColor?: string | undefined;
        borderInlineStartStyle?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "hidden" | "dashed" | "dotted" | "double" | "groove" | "inset" | "outset" | "ridge" | "solid" | undefined;
        borderInlineStartWidth?: string | number | undefined;
        borderInlineStyle?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "hidden" | "dashed" | "dotted" | "double" | "groove" | "inset" | "outset" | "ridge" | "solid" | undefined;
        borderInlineWidth?: string | number | undefined;
        borderLeftColor?: string | undefined;
        borderLeftStyle?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "hidden" | "dashed" | "dotted" | "double" | "groove" | "inset" | "outset" | "ridge" | "solid" | undefined;
        borderLeftWidth?: string | number | undefined;
        borderRightColor?: string | undefined;
        borderRightStyle?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "hidden" | "dashed" | "dotted" | "double" | "groove" | "inset" | "outset" | "ridge" | "solid" | undefined;
        borderRightWidth?: string | number | undefined;
        borderSpacing?: string | number | undefined;
        borderStartEndRadius?: string | number | undefined;
        borderStartStartRadius?: string | number | undefined;
        borderTopColor?: string | undefined;
        borderTopLeftRadius?: string | number | undefined;
        borderTopRightRadius?: string | number | undefined;
        borderTopStyle?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "hidden" | "dashed" | "dotted" | "double" | "groove" | "inset" | "outset" | "ridge" | "solid" | undefined;
        borderTopWidth?: string | number | undefined;
        bottom?: string | number | undefined;
        boxDecorationBreak?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "clone" | "slice" | undefined;
        boxShadow?: string | undefined;
        boxSizing?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "border-box" | "content-box" | undefined;
        breakAfter?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "left" | "right" | "all" | "always" | "avoid" | "avoid-column" | "avoid-page" | "avoid-region" | "column" | "page" | "recto" | "region" | "verso" | undefined;
        breakBefore?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "left" | "right" | "all" | "always" | "avoid" | "avoid-column" | "avoid-page" | "avoid-region" | "column" | "page" | "recto" | "region" | "verso" | undefined;
        breakInside?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "avoid" | "avoid-column" | "avoid-page" | "avoid-region" | undefined;
        captionSide?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "bottom" | "top" | "block-end" | "block-start" | "inline-end" | "inline-start" | undefined;
        caretColor?: string | undefined;
        clear?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "both" | "left" | "right" | "inline-end" | "inline-start" | undefined;
        clipPath?: string | undefined;
        color?: string | undefined;
        colorAdjust?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "economy" | "exact" | undefined;
        columnCount?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | undefined;
        columnFill?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "balance" | "balance-all" | undefined;
        columnGap?: string | number | undefined;
        columnRuleColor?: string | undefined;
        columnRuleStyle?: string | undefined;
        columnRuleWidth?: string | number | undefined;
        columnSpan?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "all" | undefined;
        columnWidth?: string | number | undefined;
        contain?: string | undefined;
        content?: string | undefined;
        counterIncrement?: string | undefined;
        counterReset?: string | undefined;
        counterSet?: string | undefined;
        cursor?: string | undefined;
        direction?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "ltr" | "rtl" | undefined;
        display?: string | undefined;
        emptyCells?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "hide" | "show" | undefined;
        filter?: string | undefined;
        flexBasis?: string | number | undefined;
        flexDirection?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "column" | "column-reverse" | "row" | "row-reverse" | undefined;
        flexGrow?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        flexShrink?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        flexWrap?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "nowrap" | "wrap" | "wrap-reverse" | undefined;
        float?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "left" | "right" | "inline-end" | "inline-start" | undefined;
        fontFamily?: string | undefined;
        fontFeatureSettings?: string | undefined;
        fontKerning?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "normal" | undefined;
        fontLanguageOverride?: string | undefined;
        fontOpticalSizing?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | undefined;
        fontSize?: string | number | undefined;
        fontSizeAdjust?: number | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        fontStretch?: string | undefined;
        fontStyle?: string | undefined;
        fontSynthesis?: string | undefined;
        fontVariant?: string | undefined;
        fontVariantCaps?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "normal" | "all-petite-caps" | "all-small-caps" | "petite-caps" | "small-caps" | "titling-caps" | "unicase" | undefined;
        fontVariantEastAsian?: string | undefined;
        fontVariantLigatures?: string | undefined;
        fontVariantNumeric?: string | undefined;
        fontVariantPosition?: "sub" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "normal" | "super" | undefined;
        fontVariationSettings?: string | undefined;
        fontWeight?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "normal" | "bold" | "bolder" | "lighter" | undefined;
        gridAutoColumns?: string | number | undefined;
        gridAutoFlow?: string | undefined;
        gridAutoRows?: string | number | undefined;
        gridColumnEnd?: string | number | undefined;
        gridColumnStart?: string | number | undefined;
        gridRowEnd?: string | number | undefined;
        gridRowStart?: string | number | undefined;
        gridTemplateAreas?: string | undefined;
        gridTemplateColumns?: string | number | undefined;
        gridTemplateRows?: string | number | undefined;
        hangingPunctuation?: string | undefined;
        height?: string | number | undefined;
        hyphens?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "manual" | undefined;
        imageOrientation?: string | undefined;
        imageRendering?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "-moz-crisp-edges" | "-o-crisp-edges" | "-webkit-optimize-contrast" | "crisp-edges" | "pixelated" | undefined;
        imageResolution?: string | undefined;
        initialLetter?: string | number | undefined;
        inlineSize?: string | number | undefined;
        inset?: string | number | undefined;
        insetBlock?: string | number | undefined;
        insetBlockEnd?: string | number | undefined;
        insetBlockStart?: string | number | undefined;
        insetInline?: string | number | undefined;
        insetInlineEnd?: string | number | undefined;
        insetInlineStart?: string | number | undefined;
        isolation?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "isolate" | undefined;
        justifyContent?: string | undefined;
        justifyItems?: string | undefined;
        justifySelf?: string | undefined;
        left?: string | number | undefined;
        letterSpacing?: string | number | undefined;
        lineBreak?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "normal" | "strict" | "anywhere" | "loose" | undefined;
        lineHeight?: string | number | undefined;
        lineHeightStep?: string | number | undefined;
        listStyleImage?: string | undefined;
        listStylePosition?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "inside" | "outside" | undefined;
        listStyleType?: string | undefined;
        marginBlock?: string | number | undefined;
        marginBlockEnd?: string | number | undefined;
        marginBlockStart?: string | number | undefined;
        marginBottom?: string | number | undefined;
        marginInline?: string | number | undefined;
        marginInlineEnd?: string | number | undefined;
        marginInlineStart?: string | number | undefined;
        marginLeft?: string | number | undefined;
        marginRight?: string | number | undefined;
        marginTop?: string | number | undefined;
        maskBorderMode?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "alpha" | "luminance" | undefined;
        maskBorderOutset?: string | number | undefined;
        maskBorderRepeat?: string | undefined;
        maskBorderSlice?: string | number | undefined;
        maskBorderSource?: string | undefined;
        maskBorderWidth?: string | number | undefined;
        maskClip?: string | undefined;
        maskComposite?: string | undefined;
        maskImage?: string | undefined;
        maskMode?: string | undefined;
        maskOrigin?: string | undefined;
        maskPosition?: string | number | undefined;
        maskRepeat?: string | undefined;
        maskSize?: string | number | undefined;
        maskType?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "alpha" | "luminance" | undefined;
        maxBlockSize?: string | number | undefined;
        maxHeight?: string | number | undefined;
        maxInlineSize?: string | number | undefined;
        maxLines?: number | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        maxWidth?: string | number | undefined;
        minBlockSize?: string | number | undefined;
        minHeight?: string | number | undefined;
        minInlineSize?: string | number | undefined;
        minWidth?: string | number | undefined;
        mixBlendMode?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "normal" | "color" | "color-burn" | "color-dodge" | "darken" | "difference" | "exclusion" | "hard-light" | "hue" | "lighten" | "luminosity" | "multiply" | "overlay" | "saturation" | "screen" | "soft-light" | undefined;
        motionDistance?: string | number | undefined;
        motionPath?: string | undefined;
        motionRotation?: string | undefined;
        objectFit?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "contain" | "cover" | "fill" | "scale-down" | undefined;
        objectPosition?: string | number | undefined;
        offsetAnchor?: string | number | undefined;
        offsetDistance?: string | number | undefined;
        offsetPath?: string | undefined;
        offsetPosition?: string | number | undefined;
        offsetRotate?: string | undefined;
        offsetRotation?: string | undefined;
        opacity?: string | number | undefined;
        order?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        orphans?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        outlineColor?: string | undefined;
        outlineOffset?: string | number | undefined;
        outlineStyle?: string | undefined;
        outlineWidth?: string | number | undefined;
        overflow?: string | undefined;
        overflowAnchor?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | undefined;
        overflowBlock?: "inherit" | "scroll" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "hidden" | "visible" | "clip" | undefined;
        overflowClipBox?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "content-box" | "padding-box" | undefined;
        overflowInline?: "inherit" | "scroll" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "hidden" | "visible" | "clip" | undefined;
        overflowWrap?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "normal" | "anywhere" | "break-word" | undefined;
        overflowX?: "inherit" | "scroll" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "hidden" | "visible" | "clip" | undefined;
        overflowY?: "inherit" | "scroll" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "hidden" | "visible" | "clip" | undefined;
        overscrollBehavior?: string | undefined;
        overscrollBehaviorX?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "contain" | undefined;
        overscrollBehaviorY?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "contain" | undefined;
        paddingBlock?: string | number | undefined;
        paddingBlockEnd?: string | number | undefined;
        paddingBlockStart?: string | number | undefined;
        paddingBottom?: string | number | undefined;
        paddingInline?: string | number | undefined;
        paddingInlineEnd?: string | number | undefined;
        paddingInlineStart?: string | number | undefined;
        paddingLeft?: string | number | undefined;
        paddingRight?: string | number | undefined;
        paddingTop?: string | number | undefined;
        pageBreakAfter?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "left" | "right" | "always" | "avoid" | "recto" | "verso" | undefined;
        pageBreakBefore?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "left" | "right" | "always" | "avoid" | "recto" | "verso" | undefined;
        pageBreakInside?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "avoid" | undefined;
        paintOrder?: string | undefined;
        perspective?: string | number | undefined;
        perspectiveOrigin?: string | number | undefined;
        placeContent?: string | undefined;
        pointerEvents?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "visible" | "all" | "fill" | "stroke" | "painted" | "visibleFill" | "visiblePainted" | "visibleStroke" | undefined;
        position?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "-webkit-sticky" | "absolute" | "fixed" | "relative" | "static" | "sticky" | undefined;
        quotes?: string | undefined;
        resize?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "both" | "block" | "inline" | "horizontal" | "vertical" | undefined;
        right?: string | number | undefined;
        rotate?: string | undefined;
        rowGap?: string | number | undefined;
        rubyAlign?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "space-around" | "space-between" | "center" | "start" | undefined;
        rubyMerge?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "collapse" | "separate" | undefined;
        rubyPosition?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "over" | "under" | undefined;
        scale?: string | number | undefined;
        scrollBehavior?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "smooth" | undefined;
        scrollMargin?: string | number | undefined;
        scrollMarginBlock?: string | number | undefined;
        scrollMarginBlockEnd?: string | number | undefined;
        scrollMarginBlockStart?: string | number | undefined;
        scrollMarginBottom?: string | number | undefined;
        scrollMarginInline?: string | number | undefined;
        scrollMarginInlineEnd?: string | number | undefined;
        scrollMarginInlineStart?: string | number | undefined;
        scrollMarginLeft?: string | number | undefined;
        scrollMarginRight?: string | number | undefined;
        scrollMarginTop?: string | number | undefined;
        scrollPadding?: string | number | undefined;
        scrollPaddingBlock?: string | number | undefined;
        scrollPaddingBlockEnd?: string | number | undefined;
        scrollPaddingBlockStart?: string | number | undefined;
        scrollPaddingBottom?: string | number | undefined;
        scrollPaddingInline?: string | number | undefined;
        scrollPaddingInlineEnd?: string | number | undefined;
        scrollPaddingInlineStart?: string | number | undefined;
        scrollPaddingLeft?: string | number | undefined;
        scrollPaddingRight?: string | number | undefined;
        scrollPaddingTop?: string | number | undefined;
        scrollSnapAlign?: string | undefined;
        scrollSnapStop?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "normal" | "always" | undefined;
        scrollSnapType?: string | undefined;
        scrollbarColor?: string | undefined;
        scrollbarWidth?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "thin" | undefined;
        shapeImageThreshold?: string | number | undefined;
        shapeMargin?: string | number | undefined;
        shapeOutside?: string | undefined;
        tabSize?: string | number | undefined;
        tableLayout?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "fixed" | undefined;
        textAlign?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "center" | "end" | "start" | "left" | "right" | "justify" | "match-parent" | undefined;
        textAlignLast?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "center" | "end" | "start" | "left" | "right" | "justify" | undefined;
        textCombineUpright?: string | undefined;
        textDecorationColor?: string | undefined;
        textDecorationLine?: string | undefined;
        textDecorationSkip?: string | undefined;
        textDecorationSkipInk?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | undefined;
        textDecorationStyle?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "dashed" | "dotted" | "double" | "solid" | "wavy" | undefined;
        textDecorationThickness?: string | number | undefined;
        textDecorationWidth?: string | number | undefined;
        textEmphasisColor?: string | undefined;
        textEmphasisPosition?: string | undefined;
        textEmphasisStyle?: string | undefined;
        textIndent?: string | number | undefined;
        textJustify?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "inter-character" | "inter-word" | undefined;
        textOrientation?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "mixed" | "sideways" | "upright" | undefined;
        textOverflow?: string | undefined;
        textRendering?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "geometricPrecision" | "optimizeLegibility" | "optimizeSpeed" | undefined;
        textShadow?: string | undefined;
        textSizeAdjust?: string | undefined;
        textTransform?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "full-width" | "capitalize" | "full-size-kana" | "lowercase" | "uppercase" | undefined;
        textUnderlineOffset?: string | number | undefined;
        textUnderlinePosition?: string | undefined;
        top?: string | number | undefined;
        touchAction?: string | undefined;
        transform?: string | undefined;
        transformBox?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "border-box" | "fill-box" | "view-box" | undefined;
        transformOrigin?: string | number | undefined;
        transformStyle?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "flat" | "preserve-3d" | undefined;
        transitionDelay?: string | undefined;
        transitionDuration?: string | undefined;
        transitionProperty?: string | undefined;
        transitionTimingFunction?: string | undefined;
        translate?: string | number | undefined;
        unicodeBidi?: "embed" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "normal" | "isolate" | "-moz-isolate" | "-moz-isolate-override" | "-moz-plaintext" | "-webkit-isolate" | "bidi-override" | "isolate-override" | "plaintext" | undefined;
        userSelect?: "text" | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "contain" | "all" | "-moz-none" | "element" | undefined;
        verticalAlign?: string | number | undefined;
        visibility?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "hidden" | "visible" | "collapse" | undefined;
        whiteSpace?: "pre" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "normal" | "nowrap" | "-moz-pre-wrap" | "break-spaces" | "pre-line" | "pre-wrap" | undefined;
        widows?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        width?: string | number | undefined;
        willChange?: string | undefined;
        wordBreak?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "normal" | "break-word" | "break-all" | "keep-all" | undefined;
        wordSpacing?: string | number | undefined;
        wordWrap?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "normal" | "break-word" | undefined;
        writingMode?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "horizontal-tb" | "sideways-lr" | "sideways-rl" | "vertical-lr" | "vertical-rl" | undefined;
        zIndex?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | undefined;
        zoom?: string | number | undefined;
        all?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        animation?: string | number | undefined;
        background?: string | number | undefined;
        border?: string | number | undefined;
        borderBlock?: string | number | undefined;
        borderBlockEnd?: string | number | undefined;
        borderBlockStart?: string | number | undefined;
        borderBottom?: string | number | undefined;
        borderColor?: string | undefined;
        borderImage?: string | number | undefined;
        borderInline?: string | number | undefined;
        borderInlineEnd?: string | number | undefined;
        borderInlineStart?: string | number | undefined;
        borderLeft?: string | number | undefined;
        borderRadius?: string | number | undefined;
        borderRight?: string | number | undefined;
        borderStyle?: string | undefined;
        borderTop?: string | number | undefined;
        borderWidth?: string | number | undefined;
        columnRule?: string | number | undefined;
        columns?: string | number | undefined;
        flex?: string | number | undefined;
        flexFlow?: string | undefined;
        font?: string | undefined;
        gap?: string | number | undefined;
        grid?: string | undefined;
        gridArea?: string | number | undefined;
        gridColumn?: string | number | undefined;
        gridRow?: string | number | undefined;
        gridTemplate?: string | undefined;
        lineClamp?: number | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        listStyle?: string | undefined;
        margin?: string | number | undefined;
        mask?: string | number | undefined;
        maskBorder?: string | number | undefined;
        motion?: string | number | undefined;
        offset?: string | number | undefined;
        outline?: string | number | undefined;
        padding?: string | number | undefined;
        placeItems?: string | undefined;
        placeSelf?: string | undefined;
        textDecoration?: string | number | undefined;
        textEmphasis?: string | undefined;
        transition?: string | undefined;
        MozAnimationDelay?: string | undefined;
        MozAnimationDirection?: string | undefined;
        MozAnimationDuration?: string | undefined;
        MozAnimationFillMode?: string | undefined;
        MozAnimationIterationCount?: string | number | undefined;
        MozAnimationName?: string | undefined;
        MozAnimationPlayState?: string | undefined;
        MozAnimationTimingFunction?: string | undefined;
        MozAppearance?: "button" | "menuitem" | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "button-bevel" | "checkbox" | "listbox" | "menulist" | "menulist-button" | "radio" | "searchfield" | "textfield" | "-moz-mac-unified-toolbar" | "-moz-win-borderless-glass" | "-moz-win-browsertabbar-toolbox" | "-moz-win-communications-toolbox" | "-moz-win-communicationstext" | "-moz-win-exclude-glass" | "-moz-win-glass" | "-moz-win-media-toolbox" | "-moz-win-mediatext" | "-moz-window-button-box" | "-moz-window-button-box-maximized" | "-moz-window-button-close" | "-moz-window-button-maximize" | "-moz-window-button-minimize" | "-moz-window-button-restore" | "-moz-window-frame-bottom" | "-moz-window-frame-left" | "-moz-window-frame-right" | "-moz-window-titlebar" | "-moz-window-titlebar-maximized" | "button-arrow-down" | "button-arrow-next" | "button-arrow-previous" | "button-arrow-up" | "button-focus" | "caret" | "checkbox-container" | "checkbox-label" | "checkmenuitem" | "dualbutton" | "groupbox" | "listitem" | "menuarrow" | "menubar" | "menucheckbox" | "menuimage" | "menuitemtext" | "menulist-text" | "menulist-textfield" | "menupopup" | "menuradio" | "menuseparator" | "meterbar" | "meterchunk" | "progressbar" | "progressbar-vertical" | "progresschunk" | "progresschunk-vertical" | "radio-container" | "radio-label" | "radiomenuitem" | "range" | "range-thumb" | "resizer" | "resizerpanel" | "scale-horizontal" | "scale-vertical" | "scalethumb-horizontal" | "scalethumb-vertical" | "scalethumbend" | "scalethumbstart" | "scalethumbtick" | "scrollbarbutton-down" | "scrollbarbutton-left" | "scrollbarbutton-right" | "scrollbarbutton-up" | "scrollbarthumb-horizontal" | "scrollbarthumb-vertical" | "scrollbartrack-horizontal" | "scrollbartrack-vertical" | "separator" | "sheet" | "spinner" | "spinner-downbutton" | "spinner-textfield" | "spinner-upbutton" | "splitter" | "statusbar" | "statusbarpanel" | "tab" | "tab-scroll-arrow-back" | "tab-scroll-arrow-forward" | "tabpanel" | "tabpanels" | "textfield-multiline" | "toolbar" | "toolbarbutton" | "toolbarbutton-dropdown" | "toolbargripper" | "toolbox" | "tooltip" | "treeheader" | "treeheadercell" | "treeheadersortarrow" | "treeitem" | "treeline" | "treetwisty" | "treetwistyopen" | "treeview" | undefined;
        MozBackfaceVisibility?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "hidden" | "visible" | undefined;
        MozBorderBottomColors?: string | undefined;
        MozBorderEndColor?: string | undefined;
        MozBorderEndStyle?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "hidden" | "dashed" | "dotted" | "double" | "groove" | "inset" | "outset" | "ridge" | "solid" | undefined;
        MozBorderEndWidth?: string | number | undefined;
        MozBorderLeftColors?: string | undefined;
        MozBorderRightColors?: string | undefined;
        MozBorderStartColor?: string | undefined;
        MozBorderStartStyle?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "hidden" | "dashed" | "dotted" | "double" | "groove" | "inset" | "outset" | "ridge" | "solid" | undefined;
        MozBorderTopColors?: string | undefined;
        MozBoxSizing?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "border-box" | "content-box" | undefined;
        MozColumnCount?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | undefined;
        MozColumnFill?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "balance" | "balance-all" | undefined;
        MozColumnGap?: string | number | undefined;
        MozColumnRuleColor?: string | undefined;
        MozColumnRuleStyle?: string | undefined;
        MozColumnRuleWidth?: string | number | undefined;
        MozColumnWidth?: string | number | undefined;
        MozContextProperties?: string | undefined;
        MozFloatEdge?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "border-box" | "content-box" | "padding-box" | "margin-box" | undefined;
        MozFontFeatureSettings?: string | undefined;
        MozFontLanguageOverride?: string | undefined;
        MozForceBrokenImageIcon?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        MozHyphens?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "manual" | undefined;
        MozImageRegion?: string | undefined;
        MozMarginEnd?: string | number | undefined;
        MozMarginStart?: string | number | undefined;
        MozOrient?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "block" | "inline" | "horizontal" | "vertical" | undefined;
        MozOutlineRadiusBottomleft?: string | number | undefined;
        MozOutlineRadiusBottomright?: string | number | undefined;
        MozOutlineRadiusTopleft?: string | number | undefined;
        MozOutlineRadiusTopright?: string | number | undefined;
        MozPaddingEnd?: string | number | undefined;
        MozPaddingStart?: string | number | undefined;
        MozPerspective?: string | number | undefined;
        MozPerspectiveOrigin?: string | number | undefined;
        MozStackSizing?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "ignore" | "stretch-to-fit" | undefined;
        MozTabSize?: string | number | undefined;
        MozTextSizeAdjust?: string | undefined;
        MozTransformOrigin?: string | number | undefined;
        MozTransformStyle?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "flat" | "preserve-3d" | undefined;
        MozTransitionDelay?: string | undefined;
        MozTransitionDuration?: string | undefined;
        MozTransitionProperty?: string | undefined;
        MozTransitionTimingFunction?: string | undefined;
        MozUserFocus?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "normal" | "ignore" | "select-after" | "select-all" | "select-before" | "select-menu" | "select-same" | undefined;
        MozUserModify?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "read-only" | "read-write" | "write-only" | undefined;
        MozUserSelect?: "text" | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "contain" | "all" | "-moz-none" | "element" | undefined;
        MozWindowDragging?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "drag" | "no-drag" | undefined;
        msAccelerator?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "true" | "false" | undefined;
        msAlignSelf?: string | undefined;
        msBlockProgression?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "bt" | "lr" | "rl" | "tb" | undefined;
        msContentZoomChaining?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "chained" | undefined;
        msContentZoomLimitMax?: string | undefined;
        msContentZoomLimitMin?: string | undefined;
        msContentZoomSnapPoints?: string | undefined;
        msContentZoomSnapType?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "mandatory" | "proximity" | undefined;
        msContentZooming?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "zoom" | undefined;
        msFilter?: string | undefined;
        msFlexDirection?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "column" | "column-reverse" | "row" | "row-reverse" | undefined;
        msFlexPositive?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        msFlowFrom?: string | undefined;
        msFlowInto?: string | undefined;
        msGridColumns?: string | number | undefined;
        msGridRows?: string | number | undefined;
        msHighContrastAdjust?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | undefined;
        msHyphenateLimitChars?: string | number | undefined;
        msHyphenateLimitLines?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "no-limit" | undefined;
        msHyphenateLimitZone?: string | number | undefined;
        msHyphens?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "manual" | undefined;
        msImeAlign?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "after" | undefined;
        msLineBreak?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "normal" | "strict" | "anywhere" | "loose" | undefined;
        msOrder?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        msOverflowStyle?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "-ms-autohiding-scrollbar" | "scrollbar" | undefined;
        msOverflowX?: "inherit" | "scroll" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "hidden" | "visible" | "clip" | undefined;
        msOverflowY?: "inherit" | "scroll" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "hidden" | "visible" | "clip" | undefined;
        msScrollChaining?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "chained" | undefined;
        msScrollLimitXMax?: string | number | undefined;
        msScrollLimitXMin?: string | number | undefined;
        msScrollLimitYMax?: string | number | undefined;
        msScrollLimitYMin?: string | number | undefined;
        msScrollRails?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "railed" | undefined;
        msScrollSnapPointsX?: string | undefined;
        msScrollSnapPointsY?: string | undefined;
        msScrollSnapType?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "mandatory" | "proximity" | undefined;
        msScrollTranslation?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "vertical-to-horizontal" | undefined;
        msScrollbar3dlightColor?: string | undefined;
        msScrollbarArrowColor?: string | undefined;
        msScrollbarBaseColor?: string | undefined;
        msScrollbarDarkshadowColor?: string | undefined;
        msScrollbarFaceColor?: string | undefined;
        msScrollbarHighlightColor?: string | undefined;
        msScrollbarShadowColor?: string | undefined;
        msScrollbarTrackColor?: string | undefined;
        msTextAutospace?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "ideograph-alpha" | "ideograph-numeric" | "ideograph-parenthesis" | "ideograph-space" | undefined;
        msTextCombineHorizontal?: string | undefined;
        msTextOverflow?: string | undefined;
        msTouchAction?: string | undefined;
        msTouchSelect?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "grippers" | undefined;
        msTransform?: string | undefined;
        msTransformOrigin?: string | number | undefined;
        msTransitionDelay?: string | undefined;
        msTransitionDuration?: string | undefined;
        msTransitionProperty?: string | undefined;
        msTransitionTimingFunction?: string | undefined;
        msUserSelect?: "text" | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "element" | undefined;
        msWordBreak?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "normal" | "break-word" | "break-all" | "keep-all" | undefined;
        msWrapFlow?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "end" | "start" | "both" | "clear" | "maximum" | undefined;
        msWrapMargin?: string | number | undefined;
        msWrapThrough?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "wrap" | undefined;
        msWritingMode?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "horizontal-tb" | "sideways-lr" | "sideways-rl" | "vertical-lr" | "vertical-rl" | undefined;
        OObjectFit?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "contain" | "cover" | "fill" | "scale-down" | undefined;
        OObjectPosition?: string | number | undefined;
        OTabSize?: string | number | undefined;
        OTextOverflow?: string | undefined;
        OTransformOrigin?: string | number | undefined;
        WebkitAlignContent?: string | undefined;
        WebkitAlignItems?: string | undefined;
        WebkitAlignSelf?: string | undefined;
        WebkitAnimationDelay?: string | undefined;
        WebkitAnimationDirection?: string | undefined;
        WebkitAnimationDuration?: string | undefined;
        WebkitAnimationFillMode?: string | undefined;
        WebkitAnimationIterationCount?: string | number | undefined;
        WebkitAnimationName?: string | undefined;
        WebkitAnimationPlayState?: string | undefined;
        WebkitAnimationTimingFunction?: string | undefined;
        WebkitAppearance?: "button" | "meter" | "textarea" | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "button-bevel" | "checkbox" | "listbox" | "menulist" | "menulist-button" | "progress-bar" | "push-button" | "radio" | "searchfield" | "slider-horizontal" | "square-button" | "textfield" | "caret" | "listitem" | "menulist-text" | "menulist-textfield" | "default-button" | "inner-spin-button" | "media-controls-background" | "media-controls-fullscreen-background" | "media-current-time-display" | "media-enter-fullscreen-button" | "media-exit-fullscreen-button" | "media-fullscreen-button" | "media-mute-button" | "media-overlay-play-button" | "media-play-button" | "media-seek-back-button" | "media-seek-forward-button" | "media-slider" | "media-sliderthumb" | "media-time-remaining-display" | "media-toggle-closed-captions-button" | "media-volume-slider" | "media-volume-slider-container" | "media-volume-sliderthumb" | "progress-bar-value" | "searchfield-cancel-button" | "searchfield-decoration" | "searchfield-results-button" | "searchfield-results-decoration" | "slider-vertical" | "sliderthumb-horizontal" | "sliderthumb-vertical" | undefined;
        WebkitBackdropFilter?: string | undefined;
        WebkitBackfaceVisibility?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "hidden" | "visible" | undefined;
        WebkitBackgroundClip?: string | undefined;
        WebkitBackgroundOrigin?: string | undefined;
        WebkitBackgroundSize?: string | number | undefined;
        WebkitBorderBeforeColor?: string | undefined;
        WebkitBorderBeforeStyle?: string | undefined;
        WebkitBorderBeforeWidth?: string | number | undefined;
        WebkitBorderBottomLeftRadius?: string | number | undefined;
        WebkitBorderBottomRightRadius?: string | number | undefined;
        WebkitBorderImageSlice?: string | number | undefined;
        WebkitBorderTopLeftRadius?: string | number | undefined;
        WebkitBorderTopRightRadius?: string | number | undefined;
        WebkitBoxDecorationBreak?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "clone" | "slice" | undefined;
        WebkitBoxReflect?: string | number | undefined;
        WebkitBoxShadow?: string | undefined;
        WebkitBoxSizing?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "border-box" | "content-box" | undefined;
        WebkitClipPath?: string | undefined;
        WebkitColorAdjust?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "economy" | "exact" | undefined;
        WebkitColumnCount?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | undefined;
        WebkitColumnFill?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "balance" | "balance-all" | undefined;
        WebkitColumnGap?: string | number | undefined;
        WebkitColumnRuleColor?: string | undefined;
        WebkitColumnRuleStyle?: string | undefined;
        WebkitColumnRuleWidth?: string | number | undefined;
        WebkitColumnSpan?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "all" | undefined;
        WebkitColumnWidth?: string | number | undefined;
        WebkitFilter?: string | undefined;
        WebkitFlexBasis?: string | number | undefined;
        WebkitFlexDirection?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "column" | "column-reverse" | "row" | "row-reverse" | undefined;
        WebkitFlexGrow?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitFlexShrink?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitFlexWrap?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "nowrap" | "wrap" | "wrap-reverse" | undefined;
        WebkitFontFeatureSettings?: string | undefined;
        WebkitFontKerning?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "normal" | undefined;
        WebkitFontVariantLigatures?: string | undefined;
        WebkitHyphens?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "manual" | undefined;
        WebkitJustifyContent?: string | undefined;
        WebkitLineBreak?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "normal" | "strict" | "anywhere" | "loose" | undefined;
        WebkitLineClamp?: number | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitMarginEnd?: string | number | undefined;
        WebkitMarginStart?: string | number | undefined;
        WebkitMaskAttachment?: string | undefined;
        WebkitMaskClip?: string | undefined;
        WebkitMaskComposite?: string | undefined;
        WebkitMaskImage?: string | undefined;
        WebkitMaskOrigin?: string | undefined;
        WebkitMaskPosition?: string | number | undefined;
        WebkitMaskPositionX?: string | number | undefined;
        WebkitMaskPositionY?: string | number | undefined;
        WebkitMaskRepeat?: string | undefined;
        WebkitMaskRepeatX?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "no-repeat" | "repeat" | "round" | "space" | undefined;
        WebkitMaskRepeatY?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "no-repeat" | "repeat" | "round" | "space" | undefined;
        WebkitMaskSize?: string | number | undefined;
        WebkitMaxInlineSize?: string | number | undefined;
        WebkitOrder?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitOverflowScrolling?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "touch" | undefined;
        WebkitPaddingEnd?: string | number | undefined;
        WebkitPaddingStart?: string | number | undefined;
        WebkitPerspective?: string | number | undefined;
        WebkitPerspectiveOrigin?: string | number | undefined;
        WebkitScrollSnapType?: string | undefined;
        WebkitShapeMargin?: string | number | undefined;
        WebkitTapHighlightColor?: string | undefined;
        WebkitTextCombine?: string | undefined;
        WebkitTextDecorationColor?: string | undefined;
        WebkitTextDecorationLine?: string | undefined;
        WebkitTextDecorationSkip?: string | undefined;
        WebkitTextDecorationStyle?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "dashed" | "dotted" | "double" | "solid" | "wavy" | undefined;
        WebkitTextEmphasisColor?: string | undefined;
        WebkitTextEmphasisPosition?: string | undefined;
        WebkitTextEmphasisStyle?: string | undefined;
        WebkitTextFillColor?: string | undefined;
        WebkitTextOrientation?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "mixed" | "sideways" | "upright" | undefined;
        WebkitTextSizeAdjust?: string | undefined;
        WebkitTextStrokeColor?: string | undefined;
        WebkitTextStrokeWidth?: string | number | undefined;
        WebkitTouchCallout?: "none" | "inherit" | "default" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitTransform?: string | undefined;
        WebkitTransformOrigin?: string | number | undefined;
        WebkitTransformStyle?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "flat" | "preserve-3d" | undefined;
        WebkitTransitionDelay?: string | undefined;
        WebkitTransitionDuration?: string | undefined;
        WebkitTransitionProperty?: string | undefined;
        WebkitTransitionTimingFunction?: string | undefined;
        WebkitUserModify?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "read-only" | "read-write" | "read-write-plaintext-only" | undefined;
        WebkitUserSelect?: "text" | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "contain" | "all" | "-moz-none" | "element" | undefined;
        WebkitWritingMode?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "horizontal-tb" | "sideways-lr" | "sideways-rl" | "vertical-lr" | "vertical-rl" | undefined;
        MozAnimation?: string | number | undefined;
        MozBorderImage?: string | number | undefined;
        MozColumnRule?: string | number | undefined;
        MozColumns?: string | number | undefined;
        MozTransition?: string | undefined;
        msContentZoomLimit?: string | undefined;
        msContentZoomSnap?: string | undefined;
        msFlex?: string | number | undefined;
        msScrollLimit?: string | undefined;
        msScrollSnapX?: string | undefined;
        msScrollSnapY?: string | undefined;
        msTransition?: string | undefined;
        WebkitAnimation?: string | number | undefined;
        WebkitBorderBefore?: string | number | undefined;
        WebkitBorderImage?: string | number | undefined;
        WebkitBorderRadius?: string | number | undefined;
        WebkitColumnRule?: string | number | undefined;
        WebkitColumns?: string | number | undefined;
        WebkitFlex?: string | number | undefined;
        WebkitFlexFlow?: string | undefined;
        WebkitMask?: string | number | undefined;
        WebkitTextEmphasis?: string | undefined;
        WebkitTextStroke?: string | number | undefined;
        WebkitTransition?: string | undefined;
        boxAlign?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "stretch" | "center" | "end" | "start" | "baseline" | undefined;
        boxDirection?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "normal" | "reverse" | undefined;
        boxFlex?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        boxFlexGroup?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        boxLines?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "multiple" | "single" | undefined;
        boxOrdinalGroup?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        boxOrient?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "horizontal" | "vertical" | "block-axis" | "inline-axis" | undefined;
        boxPack?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "center" | "end" | "start" | "justify" | undefined;
        clip?: string | undefined;
        fontVariantAlternates?: string | undefined;
        gridColumnGap?: string | number | undefined;
        gridGap?: string | number | undefined;
        gridRowGap?: string | number | undefined;
        imeMode?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "disabled" | "normal" | "active" | "inactive" | undefined;
        offsetBlock?: string | number | undefined;
        offsetBlockEnd?: string | number | undefined;
        offsetBlockStart?: string | number | undefined;
        offsetInline?: string | number | undefined;
        offsetInlineEnd?: string | number | undefined;
        offsetInlineStart?: string | number | undefined;
        scrollSnapCoordinate?: string | number | undefined;
        scrollSnapDestination?: string | number | undefined;
        scrollSnapPointsX?: string | undefined;
        scrollSnapPointsY?: string | undefined;
        scrollSnapTypeX?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "mandatory" | "proximity" | undefined;
        scrollSnapTypeY?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "mandatory" | "proximity" | undefined;
        textCombineHorizontal?: string | undefined;
        KhtmlBoxAlign?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "stretch" | "center" | "end" | "start" | "baseline" | undefined;
        KhtmlBoxDirection?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "normal" | "reverse" | undefined;
        KhtmlBoxFlex?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        KhtmlBoxFlexGroup?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        KhtmlBoxLines?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "multiple" | "single" | undefined;
        KhtmlBoxOrdinalGroup?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        KhtmlBoxOrient?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "horizontal" | "vertical" | "block-axis" | "inline-axis" | undefined;
        KhtmlBoxPack?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "center" | "end" | "start" | "justify" | undefined;
        KhtmlLineBreak?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "normal" | "strict" | "anywhere" | "loose" | undefined;
        KhtmlOpacity?: string | number | undefined;
        KhtmlUserSelect?: "text" | "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "contain" | "all" | "-moz-none" | "element" | undefined;
        MozBackgroundClip?: string | undefined;
        MozBackgroundInlinePolicy?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "clone" | "slice" | undefined;
        MozBackgroundOrigin?: string | undefined;
        MozBackgroundSize?: string | number | undefined;
        MozBinding?: string | undefined;
        MozBorderRadius?: string | number | undefined;
        MozBorderRadiusBottomleft?: string | number | undefined;
        MozBorderRadiusBottomright?: string | number | undefined;
        MozBorderRadiusTopleft?: string | number | undefined;
        MozBorderRadiusTopright?: string | number | undefined;
        MozBoxAlign?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "stretch" | "center" | "end" | "start" | "baseline" | undefined;
        MozBoxDirection?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "normal" | "reverse" | undefined;
        MozBoxFlex?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        MozBoxOrdinalGroup?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        MozBoxOrient?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "horizontal" | "vertical" | "block-axis" | "inline-axis" | undefined;
        MozBoxPack?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "center" | "end" | "start" | "justify" | undefined;
        MozBoxShadow?: string | undefined;
        MozOpacity?: string | number | undefined;
        MozOutline?: string | number | undefined;
        MozOutlineColor?: string | undefined;
        MozOutlineRadius?: string | number | undefined;
        MozOutlineStyle?: string | undefined;
        MozOutlineWidth?: string | number | undefined;
        MozTextAlignLast?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "center" | "end" | "start" | "left" | "right" | "justify" | undefined;
        MozTextBlink?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "blink" | undefined;
        MozTextDecorationColor?: string | undefined;
        MozTextDecorationLine?: string | undefined;
        MozTextDecorationStyle?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "dashed" | "dotted" | "double" | "solid" | "wavy" | undefined;
        MozUserInput?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "disabled" | "enabled" | undefined;
        MozWindowShadow?: "menu" | "none" | "inherit" | "default" | "-moz-initial" | "initial" | "revert" | "unset" | "sheet" | "tooltip" | undefined;
        msImeMode?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "disabled" | "normal" | "active" | "inactive" | undefined;
        OAnimation?: string | number | undefined;
        OAnimationDelay?: string | undefined;
        OAnimationDirection?: string | undefined;
        OAnimationDuration?: string | undefined;
        OAnimationFillMode?: string | undefined;
        OAnimationIterationCount?: string | number | undefined;
        OAnimationName?: string | undefined;
        OAnimationPlayState?: string | undefined;
        OAnimationTimingFunction?: string | undefined;
        OBackgroundSize?: string | number | undefined;
        OBorderImage?: string | number | undefined;
        OTransform?: string | undefined;
        OTransition?: string | undefined;
        OTransitionDelay?: string | undefined;
        OTransitionDuration?: string | undefined;
        OTransitionProperty?: string | undefined;
        OTransitionTimingFunction?: string | undefined;
        WebkitBoxAlign?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "stretch" | "center" | "end" | "start" | "baseline" | undefined;
        WebkitBoxDirection?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "normal" | "reverse" | undefined;
        WebkitBoxFlex?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitBoxFlexGroup?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitBoxLines?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "multiple" | "single" | undefined;
        WebkitBoxOrdinalGroup?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        WebkitBoxOrient?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "horizontal" | "vertical" | "block-axis" | "inline-axis" | undefined;
        WebkitBoxPack?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "center" | "end" | "start" | "justify" | undefined;
        WebkitScrollSnapPointsX?: string | undefined;
        WebkitScrollSnapPointsY?: string | undefined;
        alignmentBaseline?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "baseline" | "middle" | "after-edge" | "alphabetic" | "before-edge" | "central" | "hanging" | "ideographic" | "mathematical" | "text-after-edge" | "text-before-edge" | undefined;
        baselineShift?: string | number | undefined;
        clipRule?: "evenodd" | "nonzero" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        colorInterpolation?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "linearRGB" | "sRGB" | undefined;
        colorRendering?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "optimizeSpeed" | "optimizeQuality" | undefined;
        dominantBaseline?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "middle" | "alphabetic" | "central" | "hanging" | "ideographic" | "mathematical" | "text-after-edge" | "text-before-edge" | "no-change" | "reset-size" | "use-script" | undefined;
        fill?: string | undefined;
        fillOpacity?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        fillRule?: "evenodd" | "nonzero" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        floodColor?: string | undefined;
        floodOpacity?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        glyphOrientationVertical?: string | number | undefined;
        lightingColor?: string | undefined;
        marker?: string | undefined;
        markerEnd?: string | undefined;
        markerMid?: string | undefined;
        markerStart?: string | undefined;
        shapeRendering?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "auto" | "geometricPrecision" | "optimizeSpeed" | "crispEdges" | undefined;
        stopColor?: string | undefined;
        stopOpacity?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        stroke?: string | undefined;
        strokeDasharray?: string | number | undefined;
        strokeDashoffset?: string | number | undefined;
        strokeLinecap?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "round" | "butt" | "square" | undefined;
        strokeLinejoin?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "round" | "bevel" | "miter" | undefined;
        strokeMiterlimit?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        strokeOpacity?: number | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | undefined;
        strokeWidth?: string | number | undefined;
        textAnchor?: "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "end" | "start" | "middle" | undefined;
        vectorEffect?: "none" | "inherit" | "-moz-initial" | "initial" | "revert" | "unset" | "non-scaling-stroke" | undefined;
    };
    getTagClassName({ getPrefixCls }: ConfigConsumerProps): string;
    setVisible(visible: boolean, e: React.MouseEvent<HTMLElement>): void;
    handleIconClick: (e: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    isPresetColor(): boolean;
    renderCloseIcon(): JSX.Element | null;
    renderTag: (configProps: ConfigConsumerProps) => JSX.Element;
    render(): JSX.Element;
}
export default Tag;
