import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import * as React from 'react';
import omit from "rc-util/es/omit";
import classNames from 'classnames';
import Element from './Element';
import { ConfigContext } from '../config-provider';

var SkeletonInput = function SkeletonInput(props) {
  var _classNames;

  var customizePrefixCls = props.prefixCls,
      className = props.className,
      active = props.active,
      block = props.block;

  var _React$useContext = React.useContext(ConfigContext),
      getPrefixCls = _React$useContext.getPrefixCls;

  var prefixCls = getPrefixCls('skeleton', customizePrefixCls);
  var otherProps = omit(props, ['prefixCls']);
  var cls = classNames(prefixCls, "".concat(prefixCls, "-element"), (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-active"), active), _defineProperty(_classNames, "".concat(prefixCls, "-block"), block), _classNames), className);
  return /*#__PURE__*/React.createElement("div", {
    className: cls
  }, /*#__PURE__*/React.createElement(Element, _extends({
    prefixCls: "".concat(prefixCls, "-input")
  }, otherProps)));
};

SkeletonInput.defaultProps = {
  size: 'default'
};
export default SkeletonInput;