"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = ErrorList;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var React = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _rcMotion = _interopRequireWildcard(require("rc-motion"));

var _context = require("./context");

var _configProvider = require("../config-provider");

var _motion = _interopRequireDefault(require("../_util/motion"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var EMPTY_LIST = [];

function toErrorEntity(error, errorStatus, prefix) {
  var index = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
  return {
    key: typeof error === 'string' ? error : "".concat(prefix, "-").concat(index),
    error: error,
    errorStatus: errorStatus
  };
}

function ErrorList(_ref) {
  var help = _ref.help,
      helpStatus = _ref.helpStatus,
      _ref$errors = _ref.errors,
      errors = _ref$errors === void 0 ? EMPTY_LIST : _ref$errors,
      _ref$warnings = _ref.warnings,
      warnings = _ref$warnings === void 0 ? EMPTY_LIST : _ref$warnings,
      rootClassName = _ref.className;

  var _React$useContext = React.useContext(_context.FormItemPrefixContext),
      prefixCls = _React$useContext.prefixCls;

  var _React$useContext2 = React.useContext(_configProvider.ConfigContext),
      getPrefixCls = _React$useContext2.getPrefixCls;

  var baseClassName = "".concat(prefixCls, "-item-explain");
  var rootPrefixCls = getPrefixCls();
  var fullKeyList = React.useMemo(function () {
    if (help !== undefined && help !== null) {
      return [toErrorEntity(help, helpStatus, 'help')];
    }

    return [].concat((0, _toConsumableArray2["default"])(errors.map(function (error, index) {
      return toErrorEntity(error, 'error', 'error', index);
    })), (0, _toConsumableArray2["default"])(warnings.map(function (warning, index) {
      return toErrorEntity(warning, 'warning', 'warning', index);
    })));
  }, [help, helpStatus, errors, warnings]);
  return /*#__PURE__*/React.createElement(_rcMotion["default"], (0, _extends2["default"])({}, _motion["default"], {
    motionName: "".concat(rootPrefixCls, "-show-help"),
    motionAppear: false,
    motionEnter: false,
    visible: !!fullKeyList.length,
    onLeaveStart: function onLeaveStart(node) {
      // Force disable css override style in index.less configured
      node.style.height = 'auto';
      return {
        height: node.offsetHeight
      };
    }
  }), function (holderProps) {
    var holderClassName = holderProps.className,
        holderStyle = holderProps.style;
    return /*#__PURE__*/React.createElement("div", {
      className: (0, _classnames["default"])(baseClassName, holderClassName, rootClassName),
      style: holderStyle
    }, /*#__PURE__*/React.createElement(_rcMotion.CSSMotionList, (0, _extends2["default"])({
      keys: fullKeyList
    }, _motion["default"], {
      motionName: "".concat(rootPrefixCls, "-show-help-item"),
      component: false
    }), function (itemProps) {
      var key = itemProps.key,
          error = itemProps.error,
          errorStatus = itemProps.errorStatus,
          itemClassName = itemProps.className,
          itemStyle = itemProps.style;
      return /*#__PURE__*/React.createElement("div", {
        key: key,
        role: "alert",
        className: (0, _classnames["default"])(itemClassName, (0, _defineProperty2["default"])({}, "".concat(baseClassName, "-").concat(errorStatus), errorStatus)),
        style: itemStyle
      }, error);
    }));
  });
}