function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var __rest = this && this.__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

import * as React from 'react';
import classNames from 'classnames';
import RcInputNumber from 'rc-input-number';
import UpOutlined from '@ant-design/icons/UpOutlined';
import DownOutlined from '@ant-design/icons/DownOutlined';
import { ConfigConsumer } from '../config-provider';
import SizeContext from '../config-provider/SizeContext';
var InputNumber = /*#__PURE__*/React.forwardRef(function (props, ref) {
  var renderInputNumber = function renderInputNumber(_ref) {
    var getPrefixCls = _ref.getPrefixCls,
        direction = _ref.direction;

    var className = props.className,
        customizeSize = props.size,
        customizePrefixCls = props.prefixCls,
        others = __rest(props, ["className", "size", "prefixCls"]);

    var prefixCls = getPrefixCls('input-number', customizePrefixCls);
    var upIcon = /*#__PURE__*/React.createElement(UpOutlined, {
      className: "".concat(prefixCls, "-handler-up-inner")
    });
    var downIcon = /*#__PURE__*/React.createElement(DownOutlined, {
      className: "".concat(prefixCls, "-handler-down-inner")
    });
    return /*#__PURE__*/React.createElement(SizeContext.Consumer, null, function (size) {
      var _classNames;

      var mergeSize = customizeSize || size;
      var inputNumberClass = classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-lg"), mergeSize === 'large'), _defineProperty(_classNames, "".concat(prefixCls, "-sm"), mergeSize === 'small'), _defineProperty(_classNames, "".concat(prefixCls, "-rtl"), direction === 'rtl'), _classNames), className);
      return /*#__PURE__*/React.createElement(RcInputNumber, _extends({
        ref: ref,
        className: inputNumberClass,
        upHandler: upIcon,
        downHandler: downIcon,
        prefixCls: prefixCls
      }, others));
    });
  };

  return /*#__PURE__*/React.createElement(ConfigConsumer, null, renderInputNumber);
});
InputNumber.defaultProps = {
  step: 1
};
export default InputNumber;