import _extends from "@babel/runtime/helpers/extends";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _inherits from "@babel/runtime/helpers/inherits";
import _createSuper from "@babel/runtime/helpers/createSuper";

var __rest = this && this.__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
/**
 * Wrap of sub component which need use as Button capacity (like Icon component).
 * This helps accessibility reader to tread as a interactive button to operation.
 */


import * as React from 'react';
import KeyCode from "rc-util/es/KeyCode";
var inlineStyle = {
  border: 0,
  background: 'transparent',
  padding: 0,
  lineHeight: 'inherit',
  display: 'inline-block'
};

var TransButton = /*#__PURE__*/function (_React$Component) {
  _inherits(TransButton, _React$Component);

  var _super = _createSuper(TransButton);

  function TransButton() {
    var _this;

    _classCallCheck(this, TransButton);

    _this = _super.apply(this, arguments);

    _this.onKeyDown = function (event) {
      var keyCode = event.keyCode;

      if (keyCode === KeyCode.ENTER) {
        event.preventDefault();
      }
    };

    _this.onKeyUp = function (event) {
      var keyCode = event.keyCode;
      var onClick = _this.props.onClick;

      if (keyCode === KeyCode.ENTER && onClick) {
        onClick();
      }
    };

    _this.setRef = function (btn) {
      _this.div = btn;
    };

    return _this;
  }

  _createClass(TransButton, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var autoFocus = this.props.autoFocus;

      if (autoFocus) {
        this.focus();
      }
    }
  }, {
    key: "focus",
    value: function focus() {
      if (this.div) {
        this.div.focus();
      }
    }
  }, {
    key: "blur",
    value: function blur() {
      if (this.div) {
        this.div.blur();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _a = this.props,
          style = _a.style,
          noStyle = _a.noStyle,
          disabled = _a.disabled,
          restProps = __rest(_a, ["style", "noStyle", "disabled"]);

      var mergedStyle = {};

      if (!noStyle) {
        mergedStyle = _extends({}, inlineStyle);
      }

      if (disabled) {
        mergedStyle.pointerEvents = 'none';
      }

      mergedStyle = _extends(_extends({}, mergedStyle), style);
      return /*#__PURE__*/React.createElement("div", _extends({
        role: "button",
        tabIndex: 0,
        ref: this.setRef
      }, restProps, {
        onKeyDown: this.onKeyDown,
        onKeyUp: this.onKeyUp,
        style: mergedStyle
      }));
    }
  }]);

  return TransButton;
}(React.Component);

export default TransButton;