import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import * as React from 'react';
import Animate from 'rc-animate';
import addEventListener from "rc-util/es/Dom/addEventListener";
import classNames from 'classnames';
import omit from 'omit.js';
import VerticalAlignTopOutlined from '@ant-design/icons/VerticalAlignTopOutlined';
import throttleByAnimationFrame from '../_util/throttleByAnimationFrame';
import { ConfigContext } from '../config-provider';
import getScroll from '../_util/getScroll';
import scrollTo from '../_util/scrollTo';

var BackTop = function BackTop(props) {
  var _React$useState = React.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      visible = _React$useState2[0],
      setVisible = _React$useState2[1];

  var ref = /*#__PURE__*/React.createRef();
  var scrollEvent = React.useRef();

  var getDefaultTarget = function getDefaultTarget() {
    return ref.current && ref.current.ownerDocument ? ref.current.ownerDocument : window;
  };

  var handleScroll = throttleByAnimationFrame(function (e) {
    var visibilityHeight = props.visibilityHeight;
    var scrollTop = getScroll(e.target, true);
    setVisible(scrollTop > visibilityHeight);
  });

  var bindScrollEvent = function bindScrollEvent() {
    var target = props.target;
    var getTarget = target || getDefaultTarget;
    var container = getTarget();
    scrollEvent.current = addEventListener(container, 'scroll', function (e) {
      handleScroll(e);
    });
    handleScroll({
      target: container
    });
  };

  React.useEffect(function () {
    bindScrollEvent();
    return function () {
      if (scrollEvent.current) {
        scrollEvent.current.remove();
      }

      handleScroll.cancel();
    };
  }, [props.target]);

  var getVisible = function getVisible() {
    if ('visible' in props) {
      return props.visible;
    }

    return visible;
  };

  var scrollToTop = function scrollToTop(e) {
    var onClick = props.onClick,
        target = props.target,
        _props$duration = props.duration,
        duration = _props$duration === void 0 ? 450 : _props$duration;
    scrollTo(0, {
      getContainer: target || getDefaultTarget,
      duration: duration
    });

    if (typeof onClick === 'function') {
      onClick(e);
    }
  };

  var renderChildren = function renderChildren(_ref) {
    var prefixCls = _ref.prefixCls;
    var children = props.children;
    var defaultElement = /*#__PURE__*/React.createElement("div", {
      className: "".concat(prefixCls, "-content")
    }, /*#__PURE__*/React.createElement("div", {
      className: "".concat(prefixCls, "-icon")
    }, /*#__PURE__*/React.createElement(VerticalAlignTopOutlined, null)));
    return /*#__PURE__*/React.createElement(Animate, {
      component: "",
      transitionName: "fade"
    }, getVisible() ? /*#__PURE__*/React.createElement("div", null, children || defaultElement) : null);
  };

  var _React$useContext = React.useContext(ConfigContext),
      getPrefixCls = _React$useContext.getPrefixCls,
      direction = _React$useContext.direction;

  var customizePrefixCls = props.prefixCls,
      _props$className = props.className,
      className = _props$className === void 0 ? '' : _props$className;
  var prefixCls = getPrefixCls('back-top', customizePrefixCls);
  var classString = classNames(prefixCls, className, _defineProperty({}, "".concat(prefixCls, "-rtl"), direction === 'rtl')); // fix https://fb.me/react-unknown-prop

  var divProps = omit(props, ['prefixCls', 'className', 'children', 'visibilityHeight', 'target', 'visible']);
  return /*#__PURE__*/React.createElement("div", _extends({}, divProps, {
    className: classString,
    onClick: scrollToTop,
    ref: ref
  }), renderChildren({
    prefixCls: prefixCls
  }));
};

BackTop.defaultProps = {
  visibilityHeight: 400
};
export default /*#__PURE__*/React.memo(BackTop);