import _extends from "@babel/runtime/helpers/extends";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _inherits from "@babel/runtime/helpers/inherits";
import _createSuper from "@babel/runtime/helpers/createSuper";
import * as React from 'react';
import { SubMenu as RcSubMenu } from 'rc-menu';
import classNames from 'classnames';
import omit from 'omit.js';
import MenuContext from './MenuContext';
import { isValidElement } from '../_util/reactNode';

var SubMenu = /*#__PURE__*/function (_React$Component) {
  _inherits(SubMenu, _React$Component);

  var _super = _createSuper(SubMenu);

  function SubMenu() {
    var _this;

    _classCallCheck(this, SubMenu);

    _this = _super.apply(this, arguments);

    _this.onKeyDown = function (e) {
      _this.subMenu.onKeyDown(e);
    };

    _this.saveSubMenu = function (subMenu) {
      _this.subMenu = subMenu;
    };

    return _this;
  }

  _createClass(SubMenu, [{
    key: "renderTitle",
    value: function renderTitle(inlineCollapsed) {
      var _this$props = this.props,
          icon = _this$props.icon,
          title = _this$props.title,
          level = _this$props.level,
          rootPrefixCls = _this$props.rootPrefixCls;

      if (!icon) {
        return inlineCollapsed && level === 1 && title && typeof title === 'string' ? /*#__PURE__*/React.createElement("div", {
          className: "".concat(rootPrefixCls, "-inline-collapsed-noicon")
        }, title.charAt(0)) : title;
      } // inline-collapsed.md demo 依赖 span 来隐藏文字,有 icon 属性，则内部包裹一个 span
      // ref: https://github.com/ant-design/ant-design/pull/23456


      var titleIsSpan = isValidElement(title) && title.type === 'span';
      return /*#__PURE__*/React.createElement(React.Fragment, null, icon, titleIsSpan ? title : /*#__PURE__*/React.createElement("span", null, title));
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props2 = this.props,
          rootPrefixCls = _this$props2.rootPrefixCls,
          popupClassName = _this$props2.popupClassName;
      return /*#__PURE__*/React.createElement(MenuContext.Consumer, null, function (_ref) {
        var inlineCollapsed = _ref.inlineCollapsed,
            antdMenuTheme = _ref.antdMenuTheme;
        return /*#__PURE__*/React.createElement(RcSubMenu, _extends({}, omit(_this2.props, ['icon']), {
          title: _this2.renderTitle(inlineCollapsed),
          ref: _this2.saveSubMenu,
          popupClassName: classNames(rootPrefixCls, "".concat(rootPrefixCls, "-").concat(antdMenuTheme), popupClassName)
        }));
      });
    }
  }]);

  return SubMenu;
}(React.Component);

SubMenu.contextType = MenuContext; // fix issue:https://github.com/ant-design/ant-design/issues/8666

SubMenu.isSubMenu = 1;
export default SubMenu;