import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _inherits from "@babel/runtime/helpers/inherits";
import _createSuper from "@babel/runtime/helpers/createSuper";
import * as React from 'react';
import omit from 'omit.js';
import RcSteps from 'rc-steps';
import CheckOutlined from '@ant-design/icons/CheckOutlined';
import CloseOutlined from '@ant-design/icons/CloseOutlined';
import classNames from 'classnames';
import { ConfigConsumer } from '../config-provider';
import Progress from '../progress';

var Steps = /*#__PURE__*/function (_React$Component) {
  _inherits(Steps, _React$Component);

  var _super = _createSuper(Steps);

  function Steps() {
    var _this;

    _classCallCheck(this, Steps);

    _this = _super.apply(this, arguments);

    _this.renderSteps = function (_ref) {
      var getPrefixCls = _ref.getPrefixCls,
          direction = _ref.direction;
      var prefixCls = getPrefixCls('steps', _this.props.prefixCls);
      var iconPrefix = getPrefixCls('', _this.props.iconPrefix);
      var _this$props = _this.props,
          percent = _this$props.percent,
          size = _this$props.size;
      var className = classNames(_this.props.className, _defineProperty({}, "".concat(prefixCls, "-rtl"), direction === 'rtl'));
      var icons = {
        finish: /*#__PURE__*/React.createElement(CheckOutlined, {
          className: "".concat(prefixCls, "-finish-icon")
        }),
        error: /*#__PURE__*/React.createElement(CloseOutlined, {
          className: "".concat(prefixCls, "-error-icon")
        })
      };

      var stepIconRender = function stepIconRender(_ref2) {
        var node = _ref2.node,
            status = _ref2.status;

        if (status === 'process' && percent !== undefined) {
          // currently it's hard-coded, since we can't easily read the actually width of icon
          var progressWidth = size === 'small' ? 30 : 38;
          var iconWithProgress = /*#__PURE__*/React.createElement("div", {
            className: "".concat(prefixCls, "-progress-icon")
          }, /*#__PURE__*/React.createElement(Progress, {
            type: "circle",
            percent: percent,
            width: progressWidth,
            strokeWidth: 4,
            format: function format() {
              return null;
            }
          }), node);
          return iconWithProgress;
        }

        return node;
      };

      return /*#__PURE__*/React.createElement(RcSteps, _extends({
        icons: icons
      }, omit(_this.props, ['progress']), {
        stepIcon: stepIconRender,
        prefixCls: prefixCls,
        iconPrefix: iconPrefix,
        className: className
      }));
    };

    return _this;
  }

  _createClass(Steps, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/React.createElement(ConfigConsumer, null, this.renderSteps);
    }
  }]);

  return Steps;
}(React.Component);

export { Steps as default };
Steps.Step = RcSteps.Step;
Steps.defaultProps = {
  current: 0
};