import * as React from 'react';
import RcTextArea, { TextAreaProps as RcTextAreaProps, ResizableTextArea } from 'rc-textarea';
import ClearableLabeledInput from './ClearableLabeledInput';
import { ConfigConsumerProps } from '../config-provider';
export interface TextAreaProps extends RcTextAreaProps {
    allowClear?: boolean;
    bordered?: boolean;
}
export interface TextAreaState {
    value: any;
}
declare class TextArea extends React.Component<TextAreaProps, TextAreaState> {
    resizableTextArea: ResizableTextArea;
    clearableInput: ClearableLabeledInput;
    constructor(props: TextAreaProps);
    static getDerivedStateFromProps(nextProps: TextAreaProps): {
        value: string | number | readonly string[] | undefined;
    } | null;
    setValue(value: string, callback?: () => void): void;
    focus: () => void;
    blur(): void;
    saveTextArea: (textarea: RcTextArea) => void;
    saveClearableInput: (clearableInput: ClearableLabeledInput) => void;
    handleChange: (e: React.ChangeEvent<HTMLTextAreaElement>) => void;
    handleReset: (e: React.MouseEvent<HTMLElement, MouseEvent>) => void;
    renderTextArea: (prefixCls: string, bordered: boolean) => JSX.Element;
    renderComponent: ({ getPrefixCls, direction }: ConfigConsumerProps) => JSX.Element;
    render(): JSX.Element;
}
export default TextArea;
