"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var React = _interopRequireWildcard(require("react"));

var _ConfirmDialog = _interopRequireDefault(require("../ConfirmDialog"));

var _default2 = _interopRequireDefault(require("../../locale/default"));

var _LocaleReceiver = _interopRequireDefault(require("../../locale-provider/LocaleReceiver"));

var _configProvider = require("../../config-provider");

var HookModal = function HookModal(_ref, ref) {
  var afterClose = _ref.afterClose,
      config = _ref.config;

  var _React$useState = React.useState(true),
      _React$useState2 = (0, _slicedToArray2["default"])(_React$useState, 2),
      visible = _React$useState2[0],
      setVisible = _React$useState2[1];

  var _React$useState3 = React.useState(config),
      _React$useState4 = (0, _slicedToArray2["default"])(_React$useState3, 2),
      innerConfig = _React$useState4[0],
      setInnerConfig = _React$useState4[1];

  var _React$useContext = React.useContext(_configProvider.ConfigContext),
      direction = _React$useContext.direction;

  function close() {
    setVisible(false);
  }

  React.useImperativeHandle(ref, function () {
    return {
      destroy: close,
      update: function update(newConfig) {
        setInnerConfig(function (originConfig) {
          return (0, _extends2["default"])((0, _extends2["default"])({}, originConfig), newConfig);
        });
      }
    };
  });
  return /*#__PURE__*/React.createElement(_LocaleReceiver["default"], {
    componentName: "Modal",
    defaultLocale: _default2["default"].Modal
  }, function (modalLocale) {
    return /*#__PURE__*/React.createElement(_ConfirmDialog["default"], (0, _extends2["default"])({}, innerConfig, {
      close: close,
      visible: visible,
      afterClose: afterClose,
      okText: innerConfig.okText || (innerConfig.okCancel ? modalLocale.okText : modalLocale.justOkText),
      direction: direction,
      cancelText: innerConfig.cancelText || modalLocale.cancelText
    }));
  });
};

var _default = /*#__PURE__*/React.forwardRef(HookModal);

exports["default"] = _default;