import * as React from 'react';
import { ProgressProps } from '../progress';
export declare type UploadFileStatus = 'error' | 'success' | 'done' | 'uploading' | 'removed';
export interface HttpRequestHeader {
    [key: string]: string;
}
export interface RcFile extends File {
    uid: string;
    readonly lastModifiedDate: Date;
    readonly webkitRelativePath: string;
}
export interface RcCustomRequestOptions {
    onProgress: (event: {
        percent: number;
    }, file: RcFile) => void;
    onError: (error: Error) => void;
    onSuccess: (response: object, file: RcFile) => void;
    data: object;
    filename: string;
    file: RcFile;
    withCredentials: boolean;
    action: string;
    headers: object;
}
export interface UploadFile<T = any> {
    uid: string;
    size: number;
    name: string;
    fileName?: string;
    lastModified?: number;
    lastModifiedDate?: Date;
    url?: string;
    status?: UploadFileStatus;
    percent?: number;
    thumbUrl?: string;
    originFileObj?: File | Blob;
    response?: T;
    error?: any;
    linkProps?: any;
    type: string;
    xhr?: T;
    preview?: string;
}
export interface UploadChangeParam<T extends object = UploadFile> {
    file: T;
    fileList: Array<UploadFile>;
    event?: {
        percent: number;
    };
}
export interface ShowUploadListInterface {
    showRemoveIcon?: boolean;
    showPreviewIcon?: boolean;
    showDownloadIcon?: boolean;
}
export interface UploadLocale {
    uploading?: string;
    removeFile?: string;
    downloadFile?: string;
    uploadError?: string;
    previewFile?: string;
}
export declare type UploadType = 'drag' | 'select';
export declare type UploadListType = 'text' | 'picture' | 'picture-card';
export declare type UploadListProgressProps = Omit<ProgressProps, 'percent' | 'type'>;
declare type PreviewFileHandler = (file: File | Blob) => PromiseLike<string>;
declare type TransformFileHandler = (file: RcFile) => string | Blob | File | PromiseLike<string | Blob | File>;
export interface UploadProps<T = any> {
    type?: UploadType;
    name?: string;
    defaultFileList?: Array<UploadFile<T>>;
    fileList?: Array<UploadFile<T>>;
    action?: string | ((file: RcFile) => string) | ((file: RcFile) => PromiseLike<string>);
    directory?: boolean;
    data?: object | ((file: UploadFile<T>) => object);
    method?: 'POST' | 'PUT' | 'PATCH' | 'post' | 'put' | 'patch';
    headers?: HttpRequestHeader;
    showUploadList?: boolean | ShowUploadListInterface;
    multiple?: boolean;
    accept?: string;
    beforeUpload?: (file: RcFile, FileList: RcFile[]) => boolean | PromiseLike<void>;
    onChange?: (info: UploadChangeParam) => void;
    listType?: UploadListType;
    className?: string;
    onPreview?: (file: UploadFile<T>) => void;
    onDownload?: (file: UploadFile<T>) => void;
    onRemove?: (file: UploadFile<T>) => void | boolean | Promise<void | boolean>;
    supportServerRender?: boolean;
    style?: React.CSSProperties;
    disabled?: boolean;
    prefixCls?: string;
    customRequest?: (options: RcCustomRequestOptions) => void;
    withCredentials?: boolean;
    openFileDialogOnClick?: boolean;
    locale?: UploadLocale;
    id?: string;
    previewFile?: PreviewFileHandler;
    transformFile?: TransformFileHandler;
    iconRender?: (file: UploadFile<T>, listType?: UploadListType) => React.ReactNode;
    isImageUrl?: (file: UploadFile) => boolean;
    progress?: UploadListProgressProps;
}
export interface UploadState<T = any> {
    fileList: UploadFile<T>[];
    dragState: string;
}
export interface UploadListProps<T = any> {
    listType?: UploadListType;
    onPreview?: (file: UploadFile<T>) => void;
    onDownload?: (file: UploadFile<T>) => void;
    onRemove?: (file: UploadFile<T>) => void | boolean;
    items?: Array<UploadFile<T>>;
    progress?: UploadListProgressProps;
    prefixCls?: string;
    showRemoveIcon?: boolean;
    showDownloadIcon?: boolean;
    showPreviewIcon?: boolean;
    removeIcon?: React.ReactNode;
    downloadIcon?: React.ReactNode;
    locale: UploadLocale;
    previewFile?: PreviewFileHandler;
    iconRender?: (file: UploadFile<T>, listType?: UploadListType) => React.ReactNode;
    isImageUrl?: (file: UploadFile) => boolean;
}
export {};
