import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _extends from "@babel/runtime/helpers/extends";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _createSuper from "@babel/runtime/helpers/createSuper";

var __rest = this && this.__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

import * as React from 'react';
import RcDrawer from 'rc-drawer';
import getScrollBarSize from "rc-util/es/getScrollBarSize";
import CloseOutlined from '@ant-design/icons/CloseOutlined';
import classNames from 'classnames';
import omit from 'omit.js';
import { withConfigConsumer, ConfigConsumer } from '../config-provider/context';
import { tuple } from '../_util/type';
var DrawerContext = /*#__PURE__*/React.createContext(null);
var PlacementTypes = tuple('top', 'right', 'bottom', 'left');
var defaultPushState = {
  distance: 180
};

var Drawer = /*#__PURE__*/function (_React$Component) {
  _inherits(Drawer, _React$Component);

  var _super = _createSuper(Drawer);

  function Drawer() {
    var _this;

    _classCallCheck(this, Drawer);

    _this = _super.apply(this, arguments);
    _this.state = {
      push: false
    };

    _this.push = function () {
      if (_this.props.push) {
        _this.setState({
          push: true
        });
      }
    };

    _this.pull = function () {
      if (_this.props.push) {
        _this.setState({
          push: false
        });
      }
    };

    _this.onDestroyTransitionEnd = function () {
      var isDestroyOnClose = _this.getDestroyOnClose();

      if (!isDestroyOnClose) {
        return;
      }

      if (!_this.props.visible) {
        _this.destroyClose = true;

        _this.forceUpdate();
      }
    };

    _this.getDestroyOnClose = function () {
      return _this.props.destroyOnClose && !_this.props.visible;
    };

    _this.getPushDistance = function () {
      var push = _this.props.push;
      var distance;

      if (typeof push === 'boolean') {
        distance = push ? defaultPushState.distance : 0;
      } else {
        distance = push.distance;
      }

      return parseFloat(String(distance || 0));
    }; // get drawer push width or height


    _this.getPushTransform = function (placement) {
      var distance = _this.getPushDistance();

      if (placement === 'left' || placement === 'right') {
        return "translateX(".concat(placement === 'left' ? distance : -distance, "px)");
      }

      if (placement === 'top' || placement === 'bottom') {
        return "translateY(".concat(placement === 'top' ? distance : -distance, "px)");
      }
    };

    _this.getRcDrawerStyle = function () {
      var _this$props = _this.props,
          zIndex = _this$props.zIndex,
          placement = _this$props.placement,
          mask = _this$props.mask,
          style = _this$props.style;
      var push = _this.state.push; // 当无 mask 时，将 width 应用到外层容器上
      // 解决 https://github.com/ant-design/ant-design/issues/12401 的问题

      var offsetStyle = mask ? {} : _this.getOffsetStyle();
      return _extends(_extends({
        zIndex: zIndex,
        transform: push ? _this.getPushTransform(placement) : undefined
      }, offsetStyle), style);
    }; // render drawer body dom


    _this.renderBody = function () {
      var _this$props2 = _this.props,
          bodyStyle = _this$props2.bodyStyle,
          drawerStyle = _this$props2.drawerStyle,
          prefixCls = _this$props2.prefixCls,
          visible = _this$props2.visible;

      if (_this.destroyClose && !visible) {
        return null;
      }

      _this.destroyClose = false;
      var containerStyle = {};

      var isDestroyOnClose = _this.getDestroyOnClose();

      if (isDestroyOnClose) {
        // Increase the opacity transition, delete children after closing.
        containerStyle.opacity = 0;
        containerStyle.transition = 'opacity .3s';
      }

      return /*#__PURE__*/React.createElement("div", {
        className: "".concat(prefixCls, "-wrapper-body"),
        style: _extends(_extends({}, containerStyle), drawerStyle),
        onTransitionEnd: _this.onDestroyTransitionEnd
      }, _this.renderHeader(), /*#__PURE__*/React.createElement("div", {
        className: "".concat(prefixCls, "-body"),
        style: bodyStyle
      }, _this.props.children), _this.renderFooter());
    }; // render Provider for Multi-level drawer


    _this.renderProvider = function (value) {
      _this.parentDrawer = value;
      return /*#__PURE__*/React.createElement(ConfigConsumer, null, function (_ref) {
        var getPopupContainer = _ref.getPopupContainer,
            getPrefixCls = _ref.getPrefixCls;

        var _a = _this.props,
            customizePrefixCls = _a.prefixCls,
            placement = _a.placement,
            className = _a.className,
            mask = _a.mask,
            direction = _a.direction,
            visible = _a.visible,
            rest = __rest(_a, ["prefixCls", "placement", "className", "mask", "direction", "visible"]);

        var prefixCls = getPrefixCls('select', customizePrefixCls);
        var drawerClassName = classNames(className, _defineProperty({
          'no-mask': !mask
        }, "".concat(prefixCls, "-rtl"), direction === 'rtl'));
        var offsetStyle = mask ? _this.getOffsetStyle() : {};
        return /*#__PURE__*/React.createElement(DrawerContext.Provider, {
          value: _assertThisInitialized(_this)
        }, /*#__PURE__*/React.createElement(RcDrawer, _extends({
          handler: false
        }, omit(rest, ['zIndex', 'style', 'closable', 'closeIcon', 'destroyOnClose', 'drawerStyle', 'headerStyle', 'bodyStyle', 'footerStyle', 'footer', 'locale', 'title', 'push', 'visible', 'getPopupContainer', 'rootPrefixCls', 'getPrefixCls', 'renderEmpty', 'csp', 'pageHeader', 'autoInsertSpaceInButton', 'width', 'height', 'dropdownMatchSelectWidth', 'getTargetContainer']), {
          getContainer: // 有可能为 false，所以不能直接判断
          rest.getContainer === undefined && getPopupContainer ? function () {
            return getPopupContainer(document.body);
          } : rest.getContainer
        }, offsetStyle, {
          prefixCls: prefixCls,
          open: visible,
          showMask: mask,
          placement: placement,
          style: _this.getRcDrawerStyle(),
          className: drawerClassName
        }), _this.renderBody()));
      });
    };

    return _this;
  }

  _createClass(Drawer, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      // fix: delete drawer in child and re-render, no push started.
      // <Drawer>{show && <Drawer />}</Drawer>
      var visible = this.props.visible;

      if (visible && this.parentDrawer) {
        this.parentDrawer.push();
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(preProps) {
      var visible = this.props.visible;

      if (preProps.visible !== visible && this.parentDrawer) {
        if (visible) {
          this.parentDrawer.push();
        } else {
          this.parentDrawer.pull();
        }
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      // unmount drawer in child, clear push.
      if (this.parentDrawer) {
        this.parentDrawer.pull();
        this.parentDrawer = null;
      }
    }
  }, {
    key: "getOffsetStyle",
    value: function getOffsetStyle() {
      var _this$props3 = this.props,
          placement = _this$props3.placement,
          width = _this$props3.width,
          height = _this$props3.height,
          visible = _this$props3.visible,
          mask = _this$props3.mask; // https://github.com/ant-design/ant-design/issues/24287

      if (!visible && !mask) {
        return {};
      }

      var offsetStyle = {};

      if (placement === 'left' || placement === 'right') {
        offsetStyle.width = width;
      } else {
        offsetStyle.height = height;
      }

      return offsetStyle;
    }
  }, {
    key: "renderHeader",
    value: function renderHeader() {
      var _this$props4 = this.props,
          title = _this$props4.title,
          prefixCls = _this$props4.prefixCls,
          closable = _this$props4.closable,
          headerStyle = _this$props4.headerStyle;

      if (!title && !closable) {
        return null;
      }

      var headerClassName = title ? "".concat(prefixCls, "-header") : "".concat(prefixCls, "-header-no-title");
      return /*#__PURE__*/React.createElement("div", {
        className: headerClassName,
        style: headerStyle
      }, title && /*#__PURE__*/React.createElement("div", {
        className: "".concat(prefixCls, "-title")
      }, title), closable && this.renderCloseIcon());
    }
  }, {
    key: "renderFooter",
    value: function renderFooter() {
      var _this$props5 = this.props,
          footer = _this$props5.footer,
          footerStyle = _this$props5.footerStyle,
          prefixCls = _this$props5.prefixCls;

      if (!footer) {
        return null;
      }

      var footerClassName = "".concat(prefixCls, "-footer");
      return /*#__PURE__*/React.createElement("div", {
        className: footerClassName,
        style: footerStyle
      }, footer);
    }
  }, {
    key: "renderCloseIcon",
    value: function renderCloseIcon() {
      var _this$props6 = this.props,
          closable = _this$props6.closable,
          _this$props6$closeIco = _this$props6.closeIcon,
          closeIcon = _this$props6$closeIco === void 0 ? /*#__PURE__*/React.createElement(CloseOutlined, null) : _this$props6$closeIco,
          prefixCls = _this$props6.prefixCls,
          onClose = _this$props6.onClose;
      return closable &&
      /*#__PURE__*/
      // eslint-disable-next-line react/button-has-type
      React.createElement("button", {
        onClick: onClose,
        "aria-label": "Close",
        className: "".concat(prefixCls, "-close"),
        style: {
          '--scroll-bar': "".concat(getScrollBarSize(), "px")
        }
      }, closeIcon);
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/React.createElement(DrawerContext.Consumer, null, this.renderProvider);
    }
  }]);

  return Drawer;
}(React.Component);

Drawer.defaultProps = {
  width: 256,
  height: 256,
  closable: true,
  placement: 'right',
  maskClosable: true,
  mask: true,
  level: null,
  keyboard: true,
  push: defaultPushState
};
export default withConfigConsumer({
  prefixCls: 'drawer'
})(Drawer);