import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _extends from "@babel/runtime/helpers/extends";

var __rest = this && this.__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

import * as React from 'react';
import classNames from 'classnames';
import { composeRef } from "rc-util/es/ref";
import SearchOutlined from '@ant-design/icons/SearchOutlined';
import LoadingOutlined from '@ant-design/icons/LoadingOutlined';
import Input from './Input';
import Button from '../button';
import SizeContext from '../config-provider/SizeContext';
import { ConfigConsumer } from '../config-provider';
import { cloneElement, replaceElement } from '../_util/reactNode';
var Search = /*#__PURE__*/React.forwardRef(function (props, ref) {
  var inputRef = React.useRef(null);

  var onChange = function onChange(e) {
    var customOnChange = props.onChange,
        customOnSearch = props.onSearch;

    if (e && e.target && e.type === 'click' && customOnSearch) {
      customOnSearch(e.target.value, e);
    }

    if (customOnChange) {
      customOnChange(e);
    }
  };

  var onMouseDown = function onMouseDown(e) {
    var _a;

    if (document.activeElement === ((_a = inputRef.current) === null || _a === void 0 ? void 0 : _a.input)) {
      e.preventDefault();
    }
  };

  var onSearch = function onSearch(e) {
    var _a;

    var customOnSearch = props.onSearch,
        loading = props.loading,
        disabled = props.disabled;

    if (loading || disabled) {
      return;
    }

    if (customOnSearch) {
      customOnSearch((_a = inputRef.current) === null || _a === void 0 ? void 0 : _a.input.value, e);
    }
  };

  var renderLoading = function renderLoading(prefixCls) {
    var enterButton = props.enterButton,
        customizeSize = props.size;

    if (enterButton) {
      return /*#__PURE__*/React.createElement(SizeContext.Consumer, {
        key: "enterButton"
      }, function (size) {
        return /*#__PURE__*/React.createElement(Button, {
          className: "".concat(prefixCls, "-button"),
          type: "primary",
          size: customizeSize || size
        }, /*#__PURE__*/React.createElement(LoadingOutlined, null));
      });
    }

    return /*#__PURE__*/React.createElement(LoadingOutlined, {
      className: "".concat(prefixCls, "-icon"),
      key: "loadingIcon"
    });
  };

  var renderSuffix = function renderSuffix(prefixCls) {
    var suffix = props.suffix,
        enterButton = props.enterButton,
        loading = props.loading;

    if (loading && !enterButton) {
      return [suffix, renderLoading(prefixCls)];
    }

    if (enterButton) return suffix;
    var icon = /*#__PURE__*/React.createElement(SearchOutlined, {
      className: "".concat(prefixCls, "-icon"),
      key: "searchIcon",
      onClick: onSearch
    });

    if (suffix) {
      return [replaceElement(suffix, null, {
        key: 'suffix'
      }), icon];
    }

    return icon;
  };

  var renderAddonAfter = function renderAddonAfter(prefixCls, size) {
    var enterButton = props.enterButton,
        disabled = props.disabled,
        addonAfter = props.addonAfter,
        loading = props.loading;
    var btnClassName = "".concat(prefixCls, "-button");

    if (loading && enterButton) {
      return [renderLoading(prefixCls), addonAfter];
    }

    if (!enterButton) return addonAfter;
    var button;
    var enterButtonAsElement = enterButton;
    var isAntdButton = enterButtonAsElement.type && enterButtonAsElement.type.__ANT_BUTTON === true;

    if (isAntdButton || enterButtonAsElement.type === 'button') {
      button = cloneElement(enterButtonAsElement, _extends({
        onMouseDown: onMouseDown,
        onClick: onSearch,
        key: 'enterButton'
      }, isAntdButton ? {
        className: btnClassName,
        size: size
      } : {}));
    } else {
      button = /*#__PURE__*/React.createElement(Button, {
        className: btnClassName,
        type: "primary",
        size: size,
        disabled: disabled,
        key: "enterButton",
        onMouseDown: onMouseDown,
        onClick: onSearch
      }, enterButton === true ? /*#__PURE__*/React.createElement(SearchOutlined, null) : enterButton);
    }

    if (addonAfter) {
      return [button, replaceElement(addonAfter, null, {
        key: 'addonAfter'
      })];
    }

    return button;
  };

  var renderSearch = function renderSearch(_ref) {
    var getPrefixCls = _ref.getPrefixCls,
        direction = _ref.direction;

    var customizePrefixCls = props.prefixCls,
        customizeInputPrefixCls = props.inputPrefixCls,
        enterButton = props.enterButton,
        className = props.className,
        customizeSize = props.size,
        restProps = __rest(props, ["prefixCls", "inputPrefixCls", "enterButton", "className", "size"]);

    delete restProps.onSearch;
    delete restProps.loading;
    var prefixCls = getPrefixCls('input-search', customizePrefixCls);
    var inputPrefixCls = getPrefixCls('input', customizeInputPrefixCls);

    var getClassName = function getClassName(size) {
      var inputClassName;

      if (enterButton) {
        var _classNames;

        inputClassName = classNames(prefixCls, className, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-rtl"), direction === 'rtl'), _defineProperty(_classNames, "".concat(prefixCls, "-enter-button"), !!enterButton), _defineProperty(_classNames, "".concat(prefixCls, "-").concat(size), !!size), _classNames));
      } else {
        inputClassName = classNames(prefixCls, className, _defineProperty({}, "".concat(prefixCls, "-rtl"), direction === 'rtl'));
      }

      return inputClassName;
    };

    return /*#__PURE__*/React.createElement(SizeContext.Consumer, null, function (size) {
      return /*#__PURE__*/React.createElement(Input, _extends({
        ref: composeRef(inputRef, ref),
        onPressEnter: onSearch
      }, restProps, {
        size: customizeSize || size,
        prefixCls: inputPrefixCls,
        addonAfter: renderAddonAfter(prefixCls, customizeSize || size),
        suffix: renderSuffix(prefixCls),
        onChange: onChange,
        className: getClassName(customizeSize || size)
      }));
    });
  };

  return /*#__PURE__*/React.createElement(ConfigConsumer, null, renderSearch);
});
Search.defaultProps = {
  enterButton: false
};
Search.displayName = 'Search';
export default Search;