import * as React from 'react';
import { StoreValue } from 'rc-field-form/lib/interface';
export interface FormListFieldData {
    name: number;
    key: number;
    fieldKey: number;
}
export interface FormListOperation {
    add: (defaultValue?: StoreValue) => void;
    remove: (index: number | number[]) => void;
    move: (from: number, to: number) => void;
}
export interface FormListProps {
    name: string | number | (string | number)[];
    children: (fields: FormListFieldData[], operation: FormListOperation) => React.ReactNode;
}
declare const FormList: React.FC<FormListProps>;
export default FormList;
