import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

var __rest = this && this.__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

import * as React from 'react';
import RcTextArea from 'rc-textarea';
import omit from 'omit.js';
import classNames from 'classnames';
import useMergedState from "rc-util/es/hooks/useMergedState";
import { composeRef } from "rc-util/es/ref";
import ClearableLabeledInput from './ClearableLabeledInput';
import { ConfigContext } from '../config-provider';
import { fixControlledValue, resolveOnChange } from './Input';
import SizeContext from '../config-provider/SizeContext';
var TextArea = /*#__PURE__*/React.forwardRef(function (_a, ref) {
  var _classNames;

  var customizePrefixCls = _a.prefixCls,
      _a$bordered = _a.bordered,
      bordered = _a$bordered === void 0 ? true : _a$bordered,
      _a$showCount = _a.showCount,
      showCount = _a$showCount === void 0 ? false : _a$showCount,
      maxLength = _a.maxLength,
      className = _a.className,
      style = _a.style,
      customizeSize = _a.size,
      props = __rest(_a, ["prefixCls", "bordered", "showCount", "maxLength", "className", "style", "size"]);

  var _React$useContext = React.useContext(ConfigContext),
      getPrefixCls = _React$useContext.getPrefixCls,
      direction = _React$useContext.direction;

  var size = React.useContext(SizeContext);
  var innerRef = React.useRef();
  var clearableInputRef = React.useRef(null);

  var _useMergedState = useMergedState(props.defaultValue, {
    value: props.value
  }),
      _useMergedState2 = _slicedToArray(_useMergedState, 2),
      value = _useMergedState2[0],
      setValue = _useMergedState2[1];

  var prevValue = React.useRef(props.value);
  React.useEffect(function () {
    if (props.value !== undefined || prevValue.current !== props.value) {
      setValue(props.value);
      prevValue.current = props.value;
    }
  }, [props.value, prevValue.current]);

  var handleSetValue = function handleSetValue(val, callback) {
    if (props.value === undefined) {
      setValue(val);
      callback === null || callback === void 0 ? void 0 : callback();
    }
  };

  var handleChange = function handleChange(e) {
    handleSetValue(e.target.value);
    resolveOnChange(innerRef.current, e, props.onChange);
  };

  var handleReset = function handleReset(e) {
    handleSetValue('', function () {
      var _a;

      (_a = innerRef.current) === null || _a === void 0 ? void 0 : _a.focus();
    });
    resolveOnChange(innerRef.current, e, props.onChange);
  };

  var prefixCls = getPrefixCls('input', customizePrefixCls);
  var textArea = /*#__PURE__*/React.createElement(RcTextArea, _extends({}, omit(props, ['allowClear']), {
    maxLength: maxLength,
    className: classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-borderless"), !bordered), _defineProperty(_classNames, className, className && !showCount), _defineProperty(_classNames, "".concat(prefixCls, "-sm"), size === 'small' || customizeSize === 'small'), _defineProperty(_classNames, "".concat(prefixCls, "-lg"), size === 'large' || customizeSize === 'large'), _classNames)),
    style: showCount ? null : style,
    prefixCls: prefixCls,
    onChange: handleChange,
    ref: composeRef(ref, innerRef)
  }));
  var val = fixControlledValue(value); // Max length value

  var hasMaxLength = Number(maxLength) > 0; // fix #27612 将value转为数组进行截取，解决 '😂'.length === 2 等emoji表情导致的截取乱码的问题

  val = hasMaxLength ? _toConsumableArray(val).slice(0, maxLength).join('') : val; // TextArea

  var textareaNode = /*#__PURE__*/React.createElement(ClearableLabeledInput, _extends({}, props, {
    prefixCls: prefixCls,
    direction: direction,
    inputType: "text",
    value: val,
    element: textArea,
    handleReset: handleReset,
    ref: clearableInputRef,
    bordered: bordered
  })); // Only show text area wrapper when needed

  if (showCount) {
    var valueLength = _toConsumableArray(val).length;

    var dataCount = "".concat(valueLength).concat(hasMaxLength ? " / ".concat(maxLength) : '');
    return /*#__PURE__*/React.createElement("div", {
      className: classNames("".concat(prefixCls, "-textarea"), _defineProperty({}, "".concat(prefixCls, "-textarea-rtl"), direction === 'rtl'), "".concat(prefixCls, "-textarea-show-count"), className),
      style: style,
      "data-count": dataCount
    }, textareaNode);
  }

  return textareaNode;
});
export default TextArea;