"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var React = _interopRequireWildcard(require("react"));

var _rcTextarea = _interopRequireDefault(require("rc-textarea"));

var _omit = _interopRequireDefault(require("omit.js"));

var _classnames = _interopRequireDefault(require("classnames"));

var _useMergedState3 = _interopRequireDefault(require("rc-util/lib/hooks/useMergedState"));

var _ref = require("rc-util/lib/ref");

var _ClearableLabeledInput = _interopRequireDefault(require("./ClearableLabeledInput"));

var _configProvider = require("../config-provider");

var _Input = require("./Input");

var _SizeContext = _interopRequireDefault(require("../config-provider/SizeContext"));

var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};

  for (var p in s) {
    if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  }

  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

var TextArea = /*#__PURE__*/React.forwardRef(function (_a, ref) {
  var _classNames;

  var customizePrefixCls = _a.prefixCls,
      _a$bordered = _a.bordered,
      bordered = _a$bordered === void 0 ? true : _a$bordered,
      _a$showCount = _a.showCount,
      showCount = _a$showCount === void 0 ? false : _a$showCount,
      maxLength = _a.maxLength,
      className = _a.className,
      style = _a.style,
      customizeSize = _a.size,
      props = __rest(_a, ["prefixCls", "bordered", "showCount", "maxLength", "className", "style", "size"]);

  var _React$useContext = React.useContext(_configProvider.ConfigContext),
      getPrefixCls = _React$useContext.getPrefixCls,
      direction = _React$useContext.direction;

  var size = React.useContext(_SizeContext["default"]);
  var innerRef = React.useRef();
  var clearableInputRef = React.useRef(null);

  var _useMergedState = (0, _useMergedState3["default"])(props.defaultValue, {
    value: props.value
  }),
      _useMergedState2 = (0, _slicedToArray2["default"])(_useMergedState, 2),
      value = _useMergedState2[0],
      setValue = _useMergedState2[1];

  var prevValue = React.useRef(props.value);
  React.useEffect(function () {
    if (props.value !== undefined || prevValue.current !== props.value) {
      setValue(props.value);
      prevValue.current = props.value;
    }
  }, [props.value, prevValue.current]);

  var handleSetValue = function handleSetValue(val, callback) {
    if (props.value === undefined) {
      setValue(val);
      callback === null || callback === void 0 ? void 0 : callback();
    }
  };

  var handleChange = function handleChange(e) {
    handleSetValue(e.target.value);
    (0, _Input.resolveOnChange)(innerRef.current, e, props.onChange);
  };

  var handleReset = function handleReset(e) {
    handleSetValue('', function () {
      var _a;

      (_a = innerRef.current) === null || _a === void 0 ? void 0 : _a.focus();
    });
    (0, _Input.resolveOnChange)(innerRef.current, e, props.onChange);
  };

  var prefixCls = getPrefixCls('input', customizePrefixCls);
  var textArea = /*#__PURE__*/React.createElement(_rcTextarea["default"], (0, _extends2["default"])({}, (0, _omit["default"])(props, ['allowClear']), {
    maxLength: maxLength,
    className: (0, _classnames["default"])((_classNames = {}, (0, _defineProperty2["default"])(_classNames, "".concat(prefixCls, "-borderless"), !bordered), (0, _defineProperty2["default"])(_classNames, className, className && !showCount), (0, _defineProperty2["default"])(_classNames, "".concat(prefixCls, "-sm"), size === 'small' || customizeSize === 'small'), (0, _defineProperty2["default"])(_classNames, "".concat(prefixCls, "-lg"), size === 'large' || customizeSize === 'large'), _classNames)),
    style: showCount ? null : style,
    prefixCls: prefixCls,
    onChange: handleChange,
    ref: (0, _ref.composeRef)(ref, innerRef)
  }));
  var val = (0, _Input.fixControlledValue)(value); // Max length value

  var hasMaxLength = Number(maxLength) > 0; // fix #27612 将value转为数组进行截取，解决 '😂'.length === 2 等emoji表情导致的截取乱码的问题

  val = hasMaxLength ? (0, _toConsumableArray2["default"])(val).slice(0, maxLength).join('') : val; // TextArea

  var textareaNode = /*#__PURE__*/React.createElement(_ClearableLabeledInput["default"], (0, _extends2["default"])({}, props, {
    prefixCls: prefixCls,
    direction: direction,
    inputType: "text",
    value: val,
    element: textArea,
    handleReset: handleReset,
    ref: clearableInputRef,
    bordered: bordered
  })); // Only show text area wrapper when needed

  if (showCount) {
    var valueLength = (0, _toConsumableArray2["default"])(val).length;
    var dataCount = "".concat(valueLength).concat(hasMaxLength ? " / ".concat(maxLength) : '');
    return /*#__PURE__*/React.createElement("div", {
      className: (0, _classnames["default"])("".concat(prefixCls, "-textarea"), (0, _defineProperty2["default"])({}, "".concat(prefixCls, "-textarea-rtl"), direction === 'rtl'), "".concat(prefixCls, "-textarea-show-count"), className),
      style: style,
      "data-count": dataCount
    }, textareaNode);
  }

  return textareaNode;
});
var _default = TextArea;
exports["default"] = _default;