import * as React from 'react';
import { Popup } from 'rc-tooltip';
import classNames from 'classnames';
import { ConfigContext } from '../config-provider';
import useStyle from './style';
import { parseColor } from './util';
// ant-tooltip css-dev-only-do-not-override-w2s56n ant-tooltip-placement-top  ant-tooltip-hidden
export default function PurePanel(props) {
  const {
    prefixCls: customizePrefixCls,
    className,
    placement = 'top',
    title,
    color,
    overlayInnerStyle
  } = props;
  const {
    getPrefixCls
  } = React.useContext(ConfigContext);
  const prefixCls = getPrefixCls('tooltip', customizePrefixCls);
  const [wrapSSR, hashId] = useStyle(prefixCls, true);
  // Color
  const colorInfo = parseColor(prefixCls, color);
  const formattedOverlayInnerStyle = Object.assign(Object.assign({}, overlayInnerStyle), colorInfo.overlayStyle);
  const arrowContentStyle = colorInfo.arrowStyle;
  return wrapSSR( /*#__PURE__*/React.createElement("div", {
    className: classNames(hashId, prefixCls, `${prefixCls}-pure`, `${prefixCls}-placement-${placement}`, className, colorInfo.className),
    style: arrowContentStyle
  }, /*#__PURE__*/React.createElement(Popup, Object.assign({}, props, {
    className: hashId,
    prefixCls: prefixCls,
    overlayInnerStyle: formattedOverlayInnerStyle
  }), title)));
}