"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard").default;
var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault").default;
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _classnames = _interopRequireDefault(require("classnames"));
var _toArray = _interopRequireDefault(require("rc-util/lib/Children/toArray"));
var React = _interopRequireWildcard(require("react"));
var _configProvider = require("../config-provider");
var _menu = _interopRequireDefault(require("../menu"));
var _reactNode = require("../_util/reactNode");
var _warning = _interopRequireDefault(require("../_util/warning"));
var _BreadcrumbItem = _interopRequireDefault(require("./BreadcrumbItem"));
var _BreadcrumbSeparator = _interopRequireDefault(require("./BreadcrumbSeparator"));
var _style = _interopRequireDefault(require("./style"));
var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
function getBreadcrumbName(route, params) {
  if (!route.breadcrumbName) {
    return null;
  }
  const paramsKeys = Object.keys(params).join('|');
  const name = route.breadcrumbName.replace(new RegExp(`:(${paramsKeys})`, 'g'), (replacement, key) => params[key] || replacement);
  return name;
}
function defaultItemRender(route, params, routes, paths) {
  const isLastItem = routes.indexOf(route) === routes.length - 1;
  const name = getBreadcrumbName(route, params);
  return isLastItem ? /*#__PURE__*/React.createElement("span", null, name) : /*#__PURE__*/React.createElement("a", {
    href: `#/${paths.join('/')}`
  }, name);
}
const getPath = (path, params) => {
  path = (path || '').replace(/^\//, '');
  Object.keys(params).forEach(key => {
    path = path.replace(`:${key}`, params[key]);
  });
  return path;
};
const addChildPath = (paths, childPath, params) => {
  const originalPaths = (0, _toConsumableArray2.default)(paths);
  const path = getPath(childPath || '', params);
  if (path) {
    originalPaths.push(path);
  }
  return originalPaths;
};
const Breadcrumb = _a => {
  var {
      prefixCls: customizePrefixCls,
      separator = '/',
      style,
      className,
      rootClassName,
      routes,
      children,
      itemRender = defaultItemRender,
      params = {}
    } = _a,
    restProps = __rest(_a, ["prefixCls", "separator", "style", "className", "rootClassName", "routes", "children", "itemRender", "params"]);
  const {
    getPrefixCls,
    direction
  } = React.useContext(_configProvider.ConfigContext);
  let crumbs;
  const prefixCls = getPrefixCls('breadcrumb', customizePrefixCls);
  const [wrapSSR, hashId] = (0, _style.default)(prefixCls);
  if (routes && routes.length > 0) {
    // generated by route
    const paths = [];
    crumbs = routes.map(route => {
      const path = getPath(route.path, params);
      if (path) {
        paths.push(path);
      }
      // generated overlay by route.children
      let overlay;
      if (route.children && route.children.length) {
        overlay = /*#__PURE__*/React.createElement(_menu.default, {
          items: route.children.map(child => ({
            key: child.path || child.breadcrumbName,
            label: itemRender(child, params, routes, addChildPath(paths, child.path, params))
          }))
        });
      }
      const itemProps = {
        separator
      };
      if (overlay) {
        itemProps.overlay = overlay;
      }
      return /*#__PURE__*/React.createElement(_BreadcrumbItem.default, Object.assign({}, itemProps, {
        key: path || route.breadcrumbName
      }), itemRender(route, params, routes, paths));
    });
  } else if (children) {
    crumbs = (0, _toArray.default)(children).map((element, index) => {
      if (!element) {
        return element;
      }
      process.env.NODE_ENV !== "production" ? (0, _warning.default)(element.type && (element.type.__ANT_BREADCRUMB_ITEM === true || element.type.__ANT_BREADCRUMB_SEPARATOR === true), 'Breadcrumb', "Only accepts Breadcrumb.Item and Breadcrumb.Separator as it's children") : void 0;
      return (0, _reactNode.cloneElement)(element, {
        separator,
        key: index
      });
    });
  }
  const breadcrumbClassName = (0, _classnames.default)(prefixCls, {
    [`${prefixCls}-rtl`]: direction === 'rtl'
  }, className, rootClassName, hashId);
  return wrapSSR( /*#__PURE__*/React.createElement("nav", Object.assign({
    className: breadcrumbClassName,
    style: style
  }, restProps), /*#__PURE__*/React.createElement("ol", null, crumbs)));
};
Breadcrumb.Item = _BreadcrumbItem.default;
Breadcrumb.Separator = _BreadcrumbSeparator.default;
if (process.env.NODE_ENV !== 'production') {
  Breadcrumb.displayName = 'Breadcrumb';
}
var _default = Breadcrumb;
exports.default = _default;