"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard").default;
var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault").default;
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var React = _interopRequireWildcard(require("react"));
var _configProvider = require("../../config-provider");
var _LocaleReceiver = _interopRequireDefault(require("../../locale/LocaleReceiver"));
var _en_US = _interopRequireDefault(require("../../locale/en_US"));
var _ConfirmDialog = _interopRequireDefault(require("../ConfirmDialog"));
const HookModal = (_ref, ref) => {
  let {
    afterClose,
    config
  } = _ref;
  var _a;
  const [open, setOpen] = React.useState(true);
  const [innerConfig, setInnerConfig] = React.useState(config);
  const {
    direction,
    getPrefixCls
  } = React.useContext(_configProvider.ConfigContext);
  const prefixCls = getPrefixCls('modal');
  const rootPrefixCls = getPrefixCls();
  const close = function () {
    setOpen(false);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    const triggerCancel = args.some(param => param && param.triggerCancel);
    if (innerConfig.onCancel && triggerCancel) {
      innerConfig.onCancel.apply(innerConfig, [() => {}].concat((0, _toConsumableArray2.default)(args.slice(1))));
    }
  };
  React.useImperativeHandle(ref, () => ({
    destroy: close,
    update: newConfig => {
      setInnerConfig(originConfig => Object.assign(Object.assign({}, originConfig), newConfig));
    }
  }));
  const mergedOkCancel = (_a = innerConfig.okCancel) !== null && _a !== void 0 ? _a : innerConfig.type === 'confirm';
  return /*#__PURE__*/React.createElement(_LocaleReceiver.default, {
    componentName: "Modal",
    defaultLocale: _en_US.default.Modal
  }, contextLocale => /*#__PURE__*/React.createElement(_ConfirmDialog.default, Object.assign({
    prefixCls: prefixCls,
    rootPrefixCls: rootPrefixCls
  }, innerConfig, {
    close: close,
    open: open,
    afterClose: afterClose,
    okText: innerConfig.okText || (mergedOkCancel ? contextLocale.okText : contextLocale.justOkText),
    direction: direction,
    cancelText: innerConfig.cancelText || contextLocale.cancelText
  })));
};
var _default = /*#__PURE__*/React.forwardRef(HookModal);
exports.default = _default;