import type * as React from 'react';
interface DivProps extends React.HTMLProps<HTMLDivElement> {
    'data-testid'?: string;
}
export type NotificationPlacement = 'top' | 'topLeft' | 'topRight' | 'bottom' | 'bottomLeft' | 'bottomRight';
export type IconType = 'success' | 'info' | 'error' | 'warning';
export interface ArgsProps {
    message: React.ReactNode;
    description?: React.ReactNode;
    btn?: React.ReactNode;
    key?: React.Key;
    onClose?: () => void;
    duration?: number | null;
    icon?: React.ReactNode;
    placement?: NotificationPlacement;
    style?: React.CSSProperties;
    className?: string;
    readonly type?: IconType;
    onClick?: () => void;
    closeIcon?: React.ReactNode;
    props?: DivProps;
    role?: 'alert' | 'status';
}
type StaticFn = (args: ArgsProps) => void;
export interface NotificationInstance {
    success: StaticFn;
    error: StaticFn;
    info: StaticFn;
    warning: StaticFn;
    open: StaticFn;
    destroy(key?: React.Key): void;
}
export interface GlobalConfigProps {
    top?: number;
    bottom?: number;
    duration?: number;
    prefixCls?: string;
    getContainer?: () => HTMLElement | ShadowRoot;
    placement?: NotificationPlacement;
    closeIcon?: React.ReactNode;
    rtl?: boolean;
    maxCount?: number;
    props?: DivProps;
}
export interface NotificationConfig {
    top?: number;
    bottom?: number;
    prefixCls?: string;
    getContainer?: () => HTMLElement | ShadowRoot;
    placement?: NotificationPlacement;
    maxCount?: number;
    rtl?: boolean;
}
export {};
