"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault").default;
var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard").default;
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useItems;
var _rcMenu = require("rc-menu");
var React = _interopRequireWildcard(require("react"));
var _MenuDivider = _interopRequireDefault(require("../MenuDivider"));
var _MenuItem = _interopRequireDefault(require("../MenuItem"));
var _SubMenu = _interopRequireDefault(require("../SubMenu"));
var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
function convertItemsToNodes(list) {
  return (list || []).map((opt, index) => {
    if (opt && typeof opt === 'object') {
      const _a = opt,
        {
          label,
          children,
          key,
          type
        } = _a,
        restProps = __rest(_a, ["label", "children", "key", "type"]);
      const mergedKey = key !== null && key !== void 0 ? key : `tmp-${index}`;
      // MenuItemGroup & SubMenuItem
      if (children || type === 'group') {
        if (type === 'group') {
          // Group
          return /*#__PURE__*/React.createElement(_rcMenu.ItemGroup, Object.assign({
            key: mergedKey
          }, restProps, {
            title: label
          }), convertItemsToNodes(children));
        }
        // Sub Menu
        return /*#__PURE__*/React.createElement(_SubMenu.default, Object.assign({
          key: mergedKey
        }, restProps, {
          title: label
        }), convertItemsToNodes(children));
      }
      // MenuItem & Divider
      if (type === 'divider') {
        return /*#__PURE__*/React.createElement(_MenuDivider.default, Object.assign({
          key: mergedKey
        }, restProps));
      }
      return /*#__PURE__*/React.createElement(_MenuItem.default, Object.assign({
        key: mergedKey
      }, restProps), label);
    }
    return null;
  }).filter(opt => opt);
}
// FIXME: Move logic here in v5
/**
 * We simply convert `items` to ReactNode for reuse origin component logic. But we need move all the
 * logic from component into this hooks when in v5
 */
function useItems(items) {
  return React.useMemo(() => {
    if (!items) {
      return items;
    }
    return convertItemsToNodes(items);
  }, [items]);
}