"use strict";
/*
 * This file is released under the MIT license.
 * Copyright (c) 2023, Mike Lischke
 *
 * See LICENSE file for more info.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var _BaseSymbol_parent;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseSymbol = void 0;
const types_1 = require("./types");
/**
 * The root of the symbol table class hierarchy: a symbol can be any manageable entity (like a block), not only
 * things like variables or classes.
 * We are using a class hierarchy here, instead of an enum or similar, to allow for easy extension and certain
 * symbols can so provide additional APIs for simpler access to their sub elements, if needed.
 */
class BaseSymbol {
    constructor(name = "") {
        this.modifiers = new Set();
        this.visibility = types_1.MemberVisibility.Unknown;
        _BaseSymbol_parent.set(this, void 0);
        this.name = name;
    }
    get parent() {
        return __classPrivateFieldGet(this, _BaseSymbol_parent, "f");
    }
    get firstSibling() {
        var _a;
        if (!__classPrivateFieldGet(this, _BaseSymbol_parent, "f")) {
            return undefined;
        }
        return (_a = __classPrivateFieldGet(this, _BaseSymbol_parent, "f")) === null || _a === void 0 ? void 0 : _a.firstChild;
    }
    /**
     * @returns the symbol before this symbol in its scope.
     */
    get previousSibling() {
        if (!__classPrivateFieldGet(this, _BaseSymbol_parent, "f")) {
            return undefined;
        }
        if (!__classPrivateFieldGet(this, _BaseSymbol_parent, "f")) {
            return this;
        }
        return __classPrivateFieldGet(this, _BaseSymbol_parent, "f").previousSiblingOf(this);
    }
    /**
     * @returns the symbol following this symbol in its scope.
     */
    get nextSibling() {
        var _a;
        return (_a = __classPrivateFieldGet(this, _BaseSymbol_parent, "f")) === null || _a === void 0 ? void 0 : _a.nextSiblingOf(this);
    }
    get lastSibling() {
        var _a;
        return (_a = __classPrivateFieldGet(this, _BaseSymbol_parent, "f")) === null || _a === void 0 ? void 0 : _a.lastChild;
    }
    /**
     * @returns the next symbol in definition order, regardless of the scope.
     */
    get next() {
        var _a;
        return (_a = __classPrivateFieldGet(this, _BaseSymbol_parent, "f")) === null || _a === void 0 ? void 0 : _a.nextOf(this);
    }
    /**
     * @returns the outermost entity (below the symbol table) that holds us.
     */
    get root() {
        let run = __classPrivateFieldGet(this, _BaseSymbol_parent, "f");
        while (run) {
            if (!run.parent || this.isSymbolTable(run.parent)) {
                return run;
            }
            run = run.parent;
        }
        return run;
    }
    /**
     * @returns the symbol table we belong too or undefined if we are not yet assigned.
     */
    get symbolTable() {
        if (this.isSymbolTable(this)) {
            return this;
        }
        let run = __classPrivateFieldGet(this, _BaseSymbol_parent, "f");
        while (run) {
            if (this.isSymbolTable(run)) {
                return run;
            }
            run = run.parent;
        }
        return undefined;
    }
    /**
     * @returns the list of symbols from this one up to root.
     */
    get symbolPath() {
        const result = [];
        // eslint-disable-next-line @typescript-eslint/no-this-alias
        let run = this;
        while (run) {
            result.push(run);
            if (!run.parent) {
                break;
            }
            run = run.parent;
        }
        return result;
    }
    /**
     * This is rather an internal method and should rarely be used by external code.
     *
     * @param parent The new parent to use.
     */
    setParent(parent) {
        __classPrivateFieldSet(this, _BaseSymbol_parent, parent, "f");
    }
    /**
     * Remove this symbol from its parent scope.
     */
    removeFromParent() {
        var _a;
        (_a = __classPrivateFieldGet(this, _BaseSymbol_parent, "f")) === null || _a === void 0 ? void 0 : _a.removeSymbol(this);
        __classPrivateFieldSet(this, _BaseSymbol_parent, undefined, "f");
    }
    /**
     * Asynchronously looks up a symbol with a given name, in a bottom-up manner.
     *
     * @param name The name of the symbol to find.
     * @param localOnly If true only child symbols are returned, otherwise also symbols from the parent of this symbol
     *                  (recursively).
     *
     * @returns A promise resolving to the first symbol with a given name, in the order of appearance in this scope
     *          or any of the parent scopes (conditionally).
     */
    resolve(name, localOnly = false) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            return (_a = __classPrivateFieldGet(this, _BaseSymbol_parent, "f")) === null || _a === void 0 ? void 0 : _a.resolve(name, localOnly);
        });
    }
    /**
     * Synchronously looks up a symbol with a given name, in a bottom-up manner.
     *
     * @param name The name of the symbol to find.
     * @param localOnly If true only child symbols are returned, otherwise also symbols from the parent of this symbol
     *                  (recursively).
     *
     * @returns the first symbol with a given name, in the order of appearance in this scope
     *          or any of the parent scopes (conditionally).
     */
    resolveSync(name, localOnly = false) {
        var _a;
        return (_a = __classPrivateFieldGet(this, _BaseSymbol_parent, "f")) === null || _a === void 0 ? void 0 : _a.resolveSync(name, localOnly);
    }
    /**
     * @param t The type of objects to return.
     *
     * @returns the next enclosing parent of the given type.
     */
    getParentOfType(t) {
        let run = __classPrivateFieldGet(this, _BaseSymbol_parent, "f");
        while (run) {
            if (run instanceof t) {
                return run;
            }
            run = run.parent;
        }
        return undefined;
    }
    /**
     * Creates a qualified identifier from this symbol and its parent.
     * If `full` is true then all parents are traversed in addition to this instance.
     *
     * @param separator The string to be used between the parts.
     * @param full A flag indicating if the full path is to be returned.
     * @param includeAnonymous Use a special string for empty scope names.
     *
     * @returns the constructed qualified identifier.
     */
    qualifiedName(separator = ".", full = false, includeAnonymous = false) {
        if (!includeAnonymous && this.name.length === 0) {
            return "";
        }
        let result = this.name.length === 0 ? "<anonymous>" : this.name;
        let run = __classPrivateFieldGet(this, _BaseSymbol_parent, "f");
        while (run) {
            if (includeAnonymous || run.name.length > 0) {
                result = (run.name.length === 0 ? "<anonymous>" : run.name) + separator + result;
            }
            if (!full || !run.parent) {
                break;
            }
            run = run.parent;
        }
        return result;
    }
    /**
     * Type guard to check for ISymbolTable.
     *
     * @param candidate The object to check.
     *
     * @returns true if the object is a symbol table.
     */
    isSymbolTable(candidate) {
        return candidate.info !== undefined;
    }
}
exports.BaseSymbol = BaseSymbol;
_BaseSymbol_parent = new WeakMap();
//# sourceMappingURL=BaseSymbol.js.map