"use strict";
/*
 * This file is released under the MIT license.
 * Copyright (c) 2023, Mike Lischke
 *
 * See LICENSE file for more info.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.FundamentalType = void 0;
const types_1 = require("./types");
/** A single class for all fundamental types. They are distinguished via the kind field. */
class FundamentalType {
    constructor(name, typeKind = types_1.TypeKind.Unknown, referenceKind = types_1.ReferenceKind.Irrelevant) {
        this.name = name;
        this.typeKind = typeKind;
        this.referenceKind = referenceKind;
    }
    get baseTypes() {
        return [];
    }
    get kind() {
        return this.typeKind;
    }
    get reference() {
        return this.referenceKind;
    }
}
FundamentalType.integerType = new FundamentalType("int", types_1.TypeKind.Integer, types_1.ReferenceKind.Instance);
FundamentalType.floatType = new FundamentalType("float", types_1.TypeKind.Float, types_1.ReferenceKind.Instance);
FundamentalType.stringType = new FundamentalType("string", types_1.TypeKind.String, types_1.ReferenceKind.Instance);
FundamentalType.boolType = new FundamentalType("bool", types_1.TypeKind.Boolean, types_1.ReferenceKind.Instance);
exports.FundamentalType = FundamentalType;
//# sourceMappingURL=FundamentalType.js.map