import { Type, ReferenceKind, TypeKind } from "./types";
import { ClassSymbol } from "./ClassSymbol";
import { FieldSymbol } from "./FieldSymbol";
import { MethodSymbol } from "./MethodSymbol";
import { ScopedSymbol } from "./ScopedSymbol";
export declare class InterfaceSymbol extends ScopedSymbol implements Type {
    reference: ReferenceKind;
    /** Typescript allows an interface to extend a class, not only interfaces. */
    readonly extends: Array<ClassSymbol | InterfaceSymbol>;
    constructor(name: string, ext: Array<ClassSymbol | InterfaceSymbol>);
    get baseTypes(): Type[];
    get kind(): TypeKind;
    /**
     * @param includeInherited Not used.
     *
     * @returns a list of all methods.
     */
    getMethods(includeInherited?: boolean): Promise<MethodSymbol[]>;
    /**
     * @param includeInherited Not used.
     *
     * @returns all fields.
     */
    getFields(includeInherited?: boolean): Promise<FieldSymbol[]>;
}
