"use strict";
/*
 * This file is released under the MIT license.
 * Copyright (c) 2023, Mike Lischke
 *
 * See LICENSE file for more info.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.MethodSymbol = exports.MethodFlags = void 0;
const RoutineSymbol_1 = require("./RoutineSymbol");
var MethodFlags;
(function (MethodFlags) {
    MethodFlags[MethodFlags["None"] = 0] = "None";
    MethodFlags[MethodFlags["Virtual"] = 1] = "Virtual";
    MethodFlags[MethodFlags["Const"] = 2] = "Const";
    MethodFlags[MethodFlags["Overwritten"] = 4] = "Overwritten";
    /** Distinguished by the return type. */
    MethodFlags[MethodFlags["SetterOrGetter"] = 8] = "SetterOrGetter";
    /** Special flag used e.g. in C++ for explicit c-tors. */
    MethodFlags[MethodFlags["Explicit"] = 16] = "Explicit";
})(MethodFlags = exports.MethodFlags || (exports.MethodFlags = {}));
/** A function which belongs to a class or other outer container structure. */
class MethodSymbol extends RoutineSymbol_1.RoutineSymbol {
    constructor() {
        super(...arguments);
        this.methodFlags = MethodFlags.None;
    }
}
exports.MethodSymbol = MethodSymbol;
//# sourceMappingURL=MethodSymbol.js.map