"use strict";
/*
 * This file is released under the MIT license.
 * Copyright (c) 2023, Mike Lischke
 *
 * See LICENSE file for more info.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.RoutineSymbol = void 0;
const ParameterSymbol_1 = require("./ParameterSymbol");
const ScopedSymbol_1 = require("./ScopedSymbol");
const VariableSymbol_1 = require("./VariableSymbol");
/** A standalone function/procedure/rule. */
class RoutineSymbol extends ScopedSymbol_1.ScopedSymbol {
    constructor(name, returnType) {
        super(name);
        this.returnType = returnType;
    }
    getVariables(localOnly = true) {
        return this.getSymbolsOfType(VariableSymbol_1.VariableSymbol);
    }
    getParameters(localOnly = true) {
        return this.getSymbolsOfType(ParameterSymbol_1.ParameterSymbol);
    }
}
exports.RoutineSymbol = RoutineSymbol;
//# sourceMappingURL=RoutineSymbol.js.map