export default {
  getDefaultCfg: function getDefaultCfg() {
    return {
      // 可选 mouseenter || click
      // 选择 click 会监听 touch，mouseenter 不会监听
      trigger: 'mouseenter',
      activeState: 'active',
      inactiveState: 'inactive',
      resetSelected: false,
      shouldUpdate: function shouldUpdate() {
        return true;
      }
    };
  },
  getEvents: function getEvents() {
    if (this.get('trigger') === 'mouseenter') {
      return {
        'node:mouseenter': 'setAllItemStates',
        'combo:mouseenter': 'setAllItemStates',
        'node:mouseleave': 'clearActiveState',
        'combo:mouseleave': 'clearActiveState'
      };
    }

    return {
      'node:click': 'setAllItemStates',
      'combo:click': 'setAllItemStates',
      'canvas:click': 'clearActiveState',
      'node:touchstart': 'setOnTouchStart',
      'combo:touchstart': 'setOnTouchStart',
      'canvas:touchstart': 'clearOnTouchStart'
    };
  },
  setOnTouchStart: function setOnTouchStart(e) {
    var self = this;

    try {
      var touches = e.originalEvent.touches;
      var event1 = touches[0];
      var event2 = touches[1];

      if (event1 && event2) {
        return;
      }

      e.preventDefault();
    } catch (e) {
      console.warn('Touch original event not exist!');
    }

    self.setAllItemStates(e);
  },
  clearOnTouchStart: function clearOnTouchStart(e) {
    var self = this;

    try {
      var touches = e.originalEvent.touches;
      var event1 = touches[0];
      var event2 = touches[1];

      if (event1 && event2) {
        return;
      }

      e.preventDefault();
    } catch (e) {
      console.warn('Touch original event not exist!');
    }

    self.clearActiveState(e);
  },
  setAllItemStates: function setAllItemStates(e) {
    var item = e.item;
    var graph = this.graph;
    this.item = item;

    if (!this.shouldUpdate(e.item, {
      event: e,
      action: 'activate'
    })) {
      return;
    }

    var self = this;
    var activeState = this.activeState;
    var inactiveState = this.inactiveState;
    var nodes = graph.getNodes();
    var combos = graph.getCombos();
    var edges = graph.getEdges();
    var vEdges = graph.get('vedges');
    var nodeLength = nodes.length;
    var comboLength = combos.length;
    var edgeLength = edges.length;
    var vEdgeLength = vEdges.length;

    for (var i = 0; i < nodeLength; i++) {
      var node = nodes[i];
      var hasSelected = node.hasState('selected');

      if (self.resetSelected) {
        if (hasSelected) {
          graph.setItemState(node, 'selected', false);
        }
      }

      graph.setItemState(node, activeState, false);

      if (inactiveState) {
        graph.setItemState(node, inactiveState, true);
      }
    }

    for (var i = 0; i < comboLength; i++) {
      var combo = combos[i];
      var hasSelected = combo.hasState('selected');

      if (self.resetSelected) {
        if (hasSelected) {
          graph.setItemState(combo, 'selected', false);
        }
      }

      graph.setItemState(combo, activeState, false);

      if (inactiveState) {
        graph.setItemState(combo, inactiveState, true);
      }
    }

    for (var i = 0; i < edgeLength; i++) {
      var edge = edges[i];
      graph.setItemState(edge, activeState, false);

      if (inactiveState) {
        graph.setItemState(edge, inactiveState, true);
      }
    }

    for (var i = 0; i < vEdgeLength; i++) {
      var vEdge = vEdges[i];
      graph.setItemState(vEdge, activeState, false);

      if (inactiveState) {
        graph.setItemState(vEdge, inactiveState, true);
      }
    }

    if (inactiveState) {
      graph.setItemState(item, inactiveState, false);
    }

    graph.setItemState(item, activeState, true);
    var rEdges = item.getEdges();
    var rEdgeLegnth = rEdges.length;

    for (var i = 0; i < rEdgeLegnth; i++) {
      var edge = rEdges[i];
      var otherEnd = void 0;

      if (edge.getSource() === item) {
        otherEnd = edge.getTarget();
      } else {
        otherEnd = edge.getSource();
      }

      if (inactiveState) {
        graph.setItemState(otherEnd, inactiveState, false);
      }

      graph.setItemState(otherEnd, activeState, true);
      graph.setItemState(edge, inactiveState, false);
      graph.setItemState(edge, activeState, true);
      edge.toFront();
    }

    graph.emit('afteractivaterelations', {
      item: e.item,
      action: 'activate'
    });
  },
  clearActiveState: function clearActiveState(e) {
    var self = this;
    var graph = self.get('graph');

    if (!self.shouldUpdate(e.item, {
      event: e,
      action: 'deactivate'
    })) {
      return;
    }

    var activeState = this.activeState;
    var inactiveState = this.inactiveState;
    var autoPaint = graph.get('autoPaint');
    graph.setAutoPaint(false);
    var nodes = graph.getNodes() || [];
    var combos = graph.getCombos() || [];
    var edges = graph.getEdges() || [];
    var vEdges = graph.get('vedges') || [];
    var nodeLength = nodes.length;
    var comboLength = combos.length;
    var edgeLength = edges.length;
    var vEdgeLength = vEdges.length;

    for (var i = 0; i < nodeLength; i++) {
      var node = nodes[i];
      graph.clearItemStates(node, [activeState, inactiveState]);
    }

    for (var i = 0; i < comboLength; i++) {
      var combo = combos[i];
      graph.clearItemStates(combo, [activeState, inactiveState]);
    }

    for (var i = 0; i < edgeLength; i++) {
      var edge = edges[i];
      graph.clearItemStates(edge, [activeState, inactiveState, 'deactivate']);
    }

    for (var i = 0; i < vEdgeLength; i++) {
      var vEdge = vEdges[i];
      graph.clearItemStates(vEdge, [activeState, inactiveState, 'deactivate']);
    }

    graph.paint();
    graph.setAutoPaint(autoPaint);
    graph.emit('afteractivaterelations', {
      item: e.item || self.get('item'),
      action: 'deactivate'
    });
  }
};