import { G6Event, IG6GraphEvent, Item, ICombo } from '@antv/g6-core';
declare const _default: {
    getDefaultCfg(): object;
    getEvents(): {
        click?: string;
        dblclick?: string;
        mousedown?: string;
        mouseup?: string;
        contextmenu?: string;
        mouseenter?: string;
        mouseout?: string;
        mouseover?: string;
        mousemove?: string;
        mouseleave?: string;
        dragstart?: string;
        dragend?: string;
        drag?: string;
        dragenter?: string;
        dragleave?: string;
        dragover?: string;
        dragout?: string;
        drop?: string;
        keyup?: string;
        keydown?: string;
        wheel?: string;
        focus?: string;
        blur?: string;
        touchstart?: string;
        touchmove?: string;
        touchend?: string;
        "canvas:touchstart"?: string;
        "canvas:touchmove"?: string;
        "canvas:touchend"?: string;
        "node:touchstart"?: string;
        "node:touchmove"?: string;
        "node:touchend"?: string;
        "combo:touchstart"?: string;
        "combo:touchmove"?: string;
        "combo:touchend"?: string;
        "edge:touchstart"?: string;
        "edge:touchmove"?: string;
        "edge:touchend"?: string;
        "node:contextmenu"?: string;
        "node:click"?: string;
        "node:dblclick"?: string;
        "node:mousedown"?: string;
        "node:mouseup"?: string;
        "node:mouseenter"?: string;
        "node:mouseleave"?: string;
        "node:mousemove"?: string;
        "node:mouseout"?: string;
        "node:mouseover"?: string;
        "node:drop"?: string;
        "node:dragover"?: string;
        "node:dragenter"?: string;
        "node:dragleave"?: string;
        "node:dragstart"?: string;
        "node:drag"?: string;
        "node:dragend"?: string;
        "node:tap"?: string;
        "node:panstart"?: string;
        "node:panmove"?: string;
        "node:panend"?: string;
        "combo:contextmenu"?: string;
        "combo:click"?: string;
        "combo:dblclick"?: string;
        "combo:mousedown"?: string;
        "combo:mouseup"?: string;
        "combo:mouseenter"?: string;
        "combo:mouseleave"?: string;
        "combo:mousemove"?: string;
        "combo:mouseout"?: string;
        "combo:mouseover"?: string;
        "combo:drop"?: string;
        "combo:dragover"?: string;
        "combo:dragenter"?: string;
        "combo:dragleave"?: string;
        "combo:dragstart"?: string;
        "combo:drag"?: string;
        "combo:dragend"?: string;
        "combo:tap"?: string;
        "combo:panstart"?: string;
        "combo:panmove"?: string;
        "combo:panend"?: string;
        "edge:contextmenu"?: string;
        "edge:click"?: string;
        "edge:dblclick"?: string;
        "edge:mousedown"?: string;
        "edge:mouseup"?: string;
        "edge:mouseenter"?: string;
        "edge:mouseleave"?: string;
        "edge:mousemove"?: string;
        "edge:mouseout"?: string;
        "edge:mouseover"?: string;
        "edge:drop"?: string;
        "edge:dragover"?: string;
        "edge:dragenter"?: string;
        "edge:dragleave"?: string;
        "canvas:contextmenu"?: string;
        "canvas:click"?: string;
        "canvas:dblclick"?: string;
        "canvas:mousedown"?: string;
        "canvas:mouseup"?: string;
        "canvas:mouseenter"?: string;
        "canvas:mouseleave"?: string;
        "canvas:mousemove"?: string;
        "canvas:mouseout"?: string;
        "canvas:mouseover"?: string;
        "canvas:drop"?: string;
        "canvas:dragenter"?: string;
        "canvas:dragleave"?: string;
        "canvas:dragstart"?: string;
        "canvas:drag"?: string;
        "canvas:dragend"?: string;
        "canvas:tap"?: string;
        "canvas:panstart"?: string;
        "canvas:panmove"?: string;
        "canvas:panend"?: string;
        beforerender?: string;
        afterrender?: string;
        beforeadditem?: string;
        afteradditem?: string;
        beforeremoveitem?: string;
        afterremoveitem?: string;
        beforeupdateitem?: string;
        afterupdateitem?: string;
        beforeitemvisibilitychange?: string;
        afteritemvisibilitychange?: string;
        beforeitemstatechange?: string;
        afteritemstatechange?: string;
        beforeitemrefresh?: string;
        afteritemrefresh?: string;
        beforeitemstatesclear?: string;
        afteritemstatesclear?: string;
        beforemodechange?: string;
        aftermodechange?: string;
        beforelayout?: string;
        afterlayout?: string;
        beforecreateedge?: string;
        aftercreateedge?: string;
        beforegraphrefreshposition?: string;
        aftergraphrefreshposition?: string;
        beforegraphrefresh?: string;
        aftergraphrefresh?: string;
        beforeanimate?: string;
        afteranimate?: string;
        beforepaint?: string;
        afterpaint?: string;
        beforecollapseexpandcombo?: string;
        aftercollapseexpandcombo?: string;
        graphstatechange?: string;
        afteractivaterelations?: string;
        nodeselectchange?: string;
        tooltipchange?: string;
        wheelzoom?: string;
        viewportchange?: string;
        dragnodeend?: string;
        stackchange?: string;
        tap?: string;
        pinchstart?: string;
        pinchmove?: string;
        panstart?: string;
        panmove?: string;
        panend?: string;
    };
    validationCombo(item: ICombo): boolean;
    onTouchStart(e: IG6GraphEvent): void;
    onTouchMove(e: IG6GraphEvent): void;
    /**
     * 开始拖动节点
     * @param evt
     */
    onDragStart(evt: IG6GraphEvent): void;
    /**
     * 持续拖动节点
     * @param evt
     */
    onDrag(evt: IG6GraphEvent): void;
    /**
     * 拖动结束，设置拖动元素capture为true，更新元素位置，如果是拖动涉及到 combo，则更新 combo 结构
     * @param evt
     */
    onDragEnd(evt: IG6GraphEvent): void;
    /**
     * 拖动过程中将节点放置到 combo 上
     * @param evt
     */
    onDropCombo(evt: IG6GraphEvent): void;
    onDropCanvas(evt: IG6GraphEvent): void;
    /**
     * 拖动放置到某个 combo 中的子 node 上
     * @param evt
     */
    onDropNode(evt: IG6GraphEvent): void;
    /**
     * 将节点拖入到 Combo 中
     * @param evt
     */
    onDragEnter(evt: IG6GraphEvent): void;
    /**
     * 将节点从 Combo 中拖出
     * @param evt
     */
    onDragLeave(evt: IG6GraphEvent): void;
    updatePositions(evt: IG6GraphEvent): void;
    /**
     * 更新节点
     * @param item 拖动的节点实例
     * @param evt
     */
    update(item: Item, evt: IG6GraphEvent): void;
    /**
     * 限流更新节点
     * @param item 拖动的节点实例
     * @param evt
     */
    debounceUpdate: () => void;
    /**
     * 更新拖动元素时的delegate
     * @param {Event} e 事件句柄
     * @param {number} x 拖动单个元素时候的x坐标
     * @param {number} y 拖动单个元素时候的y坐标
     */
    updateDelegate(e: any): void;
    /**
     * 计算delegate位置，包括左上角左边及宽度和高度
     * @memberof ItemGroup
     * @return {object} 计算出来的delegate坐标信息及宽高
     */
    calculationGroupPosition(evt: IG6GraphEvent): {
        x: number;
        y: number;
        width: number;
        height: number;
        minX: number;
        minY: number;
    };
};
export default _default;
