"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Layout", {
  enumerable: true,
  get: function get() {
    return _layout.Layouts;
  }
});
Object.defineProperty(exports, "TreeLayout", {
  enumerable: true,
  get: function get() {
    return _treeLayout.default;
  }
});
exports.registerLayout = void 0;

var _layout = require("@antv/layout");

var _treeLayout = _interopRequireDefault(require("./tree-layout"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

(0, _layout.registerLayout)('grid', _layout.GridLayout);
(0, _layout.registerLayout)('random', _layout.RandomLayout);
(0, _layout.registerLayout)('force', _layout.ForceLayout);
(0, _layout.registerLayout)('circular', _layout.CircularLayout);
(0, _layout.registerLayout)('dagre', _layout.DagreLayout);
(0, _layout.registerLayout)('radial', _layout.RadialLayout);
(0, _layout.registerLayout)('concentric', _layout.ConcentricLayout);
(0, _layout.registerLayout)('mds', _layout.MDSLayout);
(0, _layout.registerLayout)('fruchterman', _layout.FruchtermanLayout);
(0, _layout.registerLayout)('fruchterman-gpu', _layout.FruchtermanGPULayout);
(0, _layout.registerLayout)('gForce', _layout.GForceLayout);
(0, _layout.registerLayout)('gForce-gpu', _layout.GForceGPULayout);
(0, _layout.registerLayout)('comboForce', _layout.ComboForceLayout);
(0, _layout.registerLayout)('forceAtlas2', _layout.ForceAtlas2Layout);

var registerLayout = function registerLayout(name, layoutOverride) {
  layoutOverride.isCustomLayout = true;
  (0, _layout.registerLayout)(name, layoutOverride);
};

exports.registerLayout = registerLayout;