import { registerLayout, getLayoutByName } from "../registy";
export class Layout {
    constructor(options) {
        const layoutClass = getLayoutByName(options.type);
        this.layoutInstance = new layoutClass(options);
    }
    layout(data) {
        return this.layoutInstance.layout(data);
    }
    updateCfg(cfg) {
        this.layoutInstance.updateCfg(cfg);
    }
    init(data) {
        this.layoutInstance.init(data);
    }
    execute() {
        this.layoutInstance.execute();
    }
    getDefaultCfg() {
        return this.layoutInstance.getDefaultCfg();
    }
    destroy() {
        return this.layoutInstance.destroy();
    }
}
// FIXME
// FOR G6
// tslint:disable-next-line
export const Layouts = new Proxy({}, {
    // tslint:disable-line
    get: (target, propKey) => {
        return getLayoutByName(propKey);
    },
    set: (target, propKey, value) => {
        registerLayout(propKey, value);
        return true;
    }
});
//# sourceMappingURL=layout.js.map