"use strict";
/**
 * @fileOverview random layout
 * @author shiwu.wyy@antfin.com
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DagreLayout = void 0;
var dagrejs_1 = __importDefault(require("dagrejs"));
var util_1 = require("../util");
var base_1 = require("./base");
/**
 * 层次布局
 */
var DagreLayout = /** @class */ (function (_super) {
    __extends(DagreLayout, _super);
    function DagreLayout(options) {
        var _this = _super.call(this) || this;
        /** layout 方向, 可选 TB, BT, LR, RL */
        _this.rankdir = "TB";
        /** 节点水平间距(px) */
        _this.nodesep = 50;
        /** 每一层节点之间间距 */
        _this.ranksep = 50;
        /** 是否保留布局连线的控制点 */
        _this.controlPoints = false;
        /** 每层节点是否根据节点数据中的 comboId 进行排序，以防止同层 combo 重叠 */
        _this.sortByCombo = false;
        /** 是否保留每条边上的dummy node */
        _this.edgeLabelSpace = true;
        /** 是否按照给定的节点顺序排序 */
        _this.keepNodeOrder = false;
        _this.nodes = [];
        _this.edges = [];
        /** 迭代结束的回调函数 */
        _this.onLayoutEnd = function () { };
        _this.updateCfg(options);
        return _this;
    }
    DagreLayout.prototype.getDefaultCfg = function () {
        return {
            rankdir: "TB",
            align: undefined,
            nodeSize: undefined,
            nodesepFunc: undefined,
            ranksepFunc: undefined,
            nodesep: 50,
            ranksep: 50,
            controlPoints: false, // 是否保留布局连线的控制点
        };
    };
    /**
     * 执行布局
     */
    DagreLayout.prototype.execute = function () {
        var _this = this;
        var self = this;
        var nodes = self.nodes, nodeSize = self.nodeSize, rankdir = self.rankdir, combos = self.combos;
        if (!nodes)
            return;
        var edges = self.edges || [];
        var g = new dagrejs_1.default.graphlib.Graph({
            multigraph: true,
            compound: true,
        });
        var nodeSizeFunc;
        if (!nodeSize) {
            nodeSizeFunc = function (d) {
                if (d.size) {
                    if (util_1.isArray(d.size)) {
                        return d.size;
                    }
                    if (util_1.isObject(d.size)) {
                        return [d.size.width || 40, d.size.height || 40];
                    }
                    return [d.size, d.size];
                }
                return [40, 40];
            };
        }
        else if (util_1.isArray(nodeSize)) {
            nodeSizeFunc = function () { return nodeSize; };
        }
        else {
            nodeSizeFunc = function () { return [nodeSize, nodeSize]; };
        }
        var horisep = getFunc(self.nodesepFunc, self.nodesep, 50);
        var vertisep = getFunc(self.ranksepFunc, self.ranksep, 50);
        if (rankdir === "LR" || rankdir === "RL") {
            horisep = getFunc(self.ranksepFunc, self.ranksep, 50);
            vertisep = getFunc(self.nodesepFunc, self.nodesep, 50);
        }
        g.setDefaultEdgeLabel(function () { return ({}); });
        g.setGraph(self);
        var comboMap = {};
        nodes.filter(function (node) { return node.layout !== false; }).forEach(function (node) {
            var size = nodeSizeFunc(node);
            var verti = vertisep(node);
            var hori = horisep(node);
            var width = size[0] + 2 * hori;
            var height = size[1] + 2 * verti;
            var layer = node.layer;
            if (util_1.isNumber(layer)) {
                // 如果有layer属性，加入到node的label中
                g.setNode(node.id, { width: width, height: height, layer: layer });
            }
            else {
                g.setNode(node.id, { width: width, height: height });
            }
            if (_this.sortByCombo && node.comboId) {
                if (!comboMap[node.comboId]) {
                    comboMap[node.comboId] = true;
                    g.setNode(node.comboId, {});
                }
                g.setParent(node.id, node.comboId);
            }
        });
        if (this.sortByCombo && combos) {
            combos.forEach(function (combo) {
                if (!combo.parentId)
                    return;
                if (!comboMap[combo.parentId]) {
                    comboMap[combo.parentId] = true;
                    g.setNode(combo.parentId, {});
                }
                g.setParent(combo.id, combo.parentId);
            });
        }
        edges.forEach(function (edge) {
            // dagrejs Wiki https://github.com/dagrejs/dagre/wiki#configuring-the-layout
            var source = util_1.getEdgeTerminal(edge, 'source');
            var target = util_1.getEdgeTerminal(edge, 'target');
            g.setEdge(source, target, {
                weight: edge.weight || 1,
            });
        });
        dagrejs_1.default.layout(g, {
            edgeLabelSpace: self.edgeLabelSpace,
            keepNodeOrder: self.keepNodeOrder,
            nodeOrder: self.nodeOrder,
        });
        var coord;
        g.nodes().forEach(function (node) {
            coord = g.node(node);
            var i = nodes.findIndex(function (it) { return it.id === node; });
            if (!nodes[i])
                return;
            nodes[i].x = coord.x;
            nodes[i].y = coord.y;
        });
        g.edges().forEach(function (edge) {
            coord = g.edge(edge);
            var i = edges.findIndex(function (it) {
                var source = util_1.getEdgeTerminal(it, 'source');
                var target = util_1.getEdgeTerminal(it, 'target');
                return source === edge.v && target === edge.w;
            });
            if ((self.edgeLabelSpace !== false) && self.controlPoints && edges[i].type !== "loop") {
                edges[i].controlPoints = coord.points.slice(1, coord.points.length - 1);
            }
        });
        if (self.onLayoutEnd)
            self.onLayoutEnd();
        return {
            nodes: nodes,
            edges: edges,
        };
    };
    DagreLayout.prototype.getType = function () {
        return "dagre";
    };
    return DagreLayout;
}(base_1.Base));
exports.DagreLayout = DagreLayout;
function getFunc(func, value, defaultValue) {
    var resultFunc;
    if (func) {
        resultFunc = func;
    }
    else if (util_1.isNumber(value)) {
        resultFunc = function () { return value; };
    }
    else {
        resultFunc = function () { return defaultValue; };
    }
    return resultFunc;
}
//# sourceMappingURL=dagre.js.map