"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Layouts = exports.Layout = void 0;
var registy_1 = require("../registy");
var Layout = /** @class */ (function () {
    function Layout(options) {
        var layoutClass = registy_1.getLayoutByName(options.type);
        this.layoutInstance = new layoutClass(options);
    }
    Layout.prototype.layout = function (data) {
        return this.layoutInstance.layout(data);
    };
    Layout.prototype.updateCfg = function (cfg) {
        this.layoutInstance.updateCfg(cfg);
    };
    Layout.prototype.init = function (data) {
        this.layoutInstance.init(data);
    };
    Layout.prototype.execute = function () {
        this.layoutInstance.execute();
    };
    Layout.prototype.getDefaultCfg = function () {
        return this.layoutInstance.getDefaultCfg();
    };
    Layout.prototype.destroy = function () {
        return this.layoutInstance.destroy();
    };
    return Layout;
}());
exports.Layout = Layout;
// FIXME
// FOR G6
// tslint:disable-next-line
exports.Layouts = new Proxy({}, {
    // tslint:disable-line
    get: function (target, propKey) {
        return registy_1.getLayoutByName(propKey);
    },
    set: function (target, propKey, value) {
        registy_1.registerLayout(propKey, value);
        return true;
    }
});
//# sourceMappingURL=layout.js.map