"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Poly = void 0;
var base_1 = require("../base");
var geometry_1 = require("../../geometry");
var util_1 = require("../../util");
var Poly = /** @class */ (function (_super) {
    __extends(Poly, _super);
    function Poly() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(Poly.prototype, "points", {
        get: function () {
            return this.getPoints();
        },
        set: function (pts) {
            this.setPoints(pts);
        },
        enumerable: false,
        configurable: true
    });
    Poly.prototype.getPoints = function () {
        return this.getAttrByPath('body/refPoints');
    };
    Poly.prototype.setPoints = function (points, options) {
        if (points == null) {
            this.removePoints();
        }
        else {
            this.setAttrByPath('body/refPoints', Poly.pointsToString(points), options);
        }
        return this;
    };
    Poly.prototype.removePoints = function () {
        this.removeAttrByPath('body/refPoints');
        return this;
    };
    return Poly;
}(base_1.Base));
exports.Poly = Poly;
(function (Poly) {
    function pointsToString(points) {
        return typeof points === 'string'
            ? points
            : points
                .map(function (p) {
                if (Array.isArray(p)) {
                    return p.join(',');
                }
                if (geometry_1.Point.isPointLike(p)) {
                    return p.x + ", " + p.y;
                }
                return '';
            })
                .join(' ');
    }
    Poly.pointsToString = pointsToString;
    Poly.config({
        propHooks: function (metadata) {
            var points = metadata.points, others = __rest(metadata, ["points"]);
            if (points) {
                var data = pointsToString(points);
                if (data) {
                    util_1.ObjectExt.setByPath(others, 'attrs/body/refPoints', data);
                }
            }
            return others;
        },
    });
})(Poly = exports.Poly || (exports.Poly = {}));
exports.Poly = Poly;
//# sourceMappingURL=poly.js.map