/// <reference types="flatbuffers" />
export { DateUnit, TimeUnit, Precision, UnionMode, IntervalUnit, MetadataVersion, } from './fb/Schema';
export { MessageHeader } from './fb/Message';
export { Type, BufferType } from './enum';
export { Data } from './data';
export { DataType, Null, Bool, Int, Int8, Int16, Int32, Int64, Uint8, Uint16, Uint32, Uint64, Float, Float16, Float32, Float64, Utf8, Binary, FixedSizeBinary, Date_, DateDay, DateMillisecond, Timestamp, TimestampSecond, TimestampMillisecond, TimestampMicrosecond, TimestampNanosecond, Time, TimeSecond, TimeMillisecond, TimeMicrosecond, TimeNanosecond, Decimal, List, Struct, Union, DenseUnion, SparseUnion, Dictionary, Interval, IntervalDayTime, IntervalYearMonth, FixedSizeList, Map_, } from './type';
export { Table } from './table';
export { Column } from './column';
export { Visitor } from './visitor';
export { Schema, Field } from './schema';
export { Vector, BaseVector, BinaryVector, BoolVector, Chunked, DateVector, DateDayVector, DateMillisecondVector, DecimalVector, DictionaryVector, FixedSizeBinaryVector, FixedSizeListVector, FloatVector, Float16Vector, Float32Vector, Float64Vector, IntervalVector, IntervalDayTimeVector, IntervalYearMonthVector, IntVector, Int8Vector, Int16Vector, Int32Vector, Int64Vector, Uint8Vector, Uint16Vector, Uint32Vector, Uint64Vector, ListVector, MapVector, NullVector, StructVector, TimestampVector, TimestampSecondVector, TimestampMillisecondVector, TimestampMicrosecondVector, TimestampNanosecondVector, TimeVector, TimeSecondVector, TimeMillisecondVector, TimeMicrosecondVector, TimeNanosecondVector, UnionVector, DenseUnionVector, SparseUnionVector, Utf8Vector, } from './vector/index';
export { Builder, BinaryBuilder, BoolBuilder, DateBuilder, DateDayBuilder, DateMillisecondBuilder, DecimalBuilder, DictionaryBuilder, FixedSizeBinaryBuilder, FixedSizeListBuilder, FloatBuilder, Float16Builder, Float32Builder, Float64Builder, IntervalBuilder, IntervalDayTimeBuilder, IntervalYearMonthBuilder, IntBuilder, Int8Builder, Int16Builder, Int32Builder, Int64Builder, Uint8Builder, Uint16Builder, Uint32Builder, Uint64Builder, ListBuilder, MapBuilder, NullBuilder, StructBuilder, TimestampBuilder, TimestampSecondBuilder, TimestampMillisecondBuilder, TimestampMicrosecondBuilder, TimestampNanosecondBuilder, TimeBuilder, TimeSecondBuilder, TimeMillisecondBuilder, TimeMicrosecondBuilder, TimeNanosecondBuilder, UnionBuilder, DenseUnionBuilder, SparseUnionBuilder, Utf8Builder, } from './builder/index';
export { ByteStream, AsyncByteStream, AsyncByteQueue, ReadableSource, WritableSink } from './io/stream';
export { RecordBatchReader, RecordBatchFileReader, RecordBatchStreamReader, AsyncRecordBatchFileReader, AsyncRecordBatchStreamReader } from './ipc/reader';
export { RecordBatchWriter, RecordBatchFileWriter, RecordBatchStreamWriter, RecordBatchJSONWriter } from './ipc/writer';
export { MessageReader, AsyncMessageReader, JSONMessageReader } from './ipc/message';
export { Message } from './ipc/metadata/message';
export { RecordBatch } from './recordbatch';
export { ArrowJSONLike, FileHandle, Readable, Writable, ReadableWritable, ReadableDOMStreamOptions } from './io/interfaces';
export { DataFrame, FilteredDataFrame, CountByResult, BindFunc, NextFunc } from './compute/dataframe';
import * as util_bn_ from './util/bn';
import * as util_int_ from './util/int';
import * as util_bit_ from './util/bit';
import * as util_buffer_ from './util/buffer';
import * as predicate from './compute/predicate';
import { compareSchemas, compareFields, compareTypes } from './visitor/typecomparator';
export { predicate };
/** @ignore */
export declare const util: {
    compareSchemas: typeof compareSchemas;
    compareFields: typeof compareFields;
    compareTypes: typeof compareTypes;
    clampIndex<T extends {
        length: number;
        stride?: number | undefined;
    }>(source: T, index: number): number;
    clampIndex<T_1 extends {
        length: number;
        stride?: number | undefined;
    }, N extends (source: T_1, index: number) => any = (source: T_1, index: number) => any>(source: T_1, index: number, then: N): ReturnType<N>;
    clampRange<T_2 extends {
        length: number;
        stride?: number | undefined;
    }>(source: T_2, begin: number | undefined, end: number | undefined): [number, number];
    clampRange<T_3 extends {
        length: number;
        stride?: number | undefined;
    }, N_1 extends (source: T_3, offset: number, length: number) => any = (source: T_3, offset: number, length: number) => any>(source: T_3, begin: number | undefined, end: number | undefined, then: N_1): ReturnType<N_1>;
    createElementComparator(search: any): ((value: any) => boolean) | (() => boolean);
    memcpy<TTarget extends ArrayBufferView, TSource extends ArrayBufferView>(target: TTarget, source: TSource, targetByteOffset?: number, sourceByteLength?: number): TTarget;
    joinUint8Arrays(chunks: Uint8Array[], size?: number | null | undefined): [Uint8Array, Uint8Array[], number];
    toArrayBufferView<T_4 extends import("./interfaces").TypedArray>(ArrayBufferViewCtor: import("./interfaces").TypedArrayConstructor<T_4>, input: util_buffer_.ArrayBufferViewInput): T_4;
    toArrayBufferView<T_5 extends import("./interfaces").BigIntArray>(ArrayBufferViewCtor: import("./interfaces").BigIntArrayConstructor<T_5>, input: util_buffer_.ArrayBufferViewInput): T_5;
    toArrayBufferViewIterator<T_6 extends import("./interfaces").TypedArray>(ArrayCtor: import("./interfaces").TypedArrayConstructor<T_6>, source: string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | IteratorReturnResult<any> | IteratorYieldResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadValueResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadDoneResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | Iterable<util_buffer_.ArrayBufferViewInput> | null | undefined): Generator<T_6, T_6, number | undefined>;
    toArrayBufferViewAsyncIterator<T_7 extends import("./interfaces").TypedArray>(ArrayCtor: import("./interfaces").TypedArrayConstructor<T_7>, source: string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | IteratorReturnResult<any> | IteratorYieldResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadValueResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadDoneResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | AsyncIterable<util_buffer_.ArrayBufferViewInput> | Iterable<util_buffer_.ArrayBufferViewInput> | PromiseLike<util_buffer_.ArrayBufferViewInput> | null | undefined): AsyncGenerator<T_7, T_7, number | undefined>;
    rebaseValueOffsets(offset: number, length: number, valueOffsets: Int32Array): Int32Array;
    compareArrayLike<T_8 extends ArrayLike<any>>(a: T_8, b: T_8): boolean;
    toInt8Array: (input: util_buffer_.ArrayBufferViewInput) => Int8Array;
    toInt16Array: (input: util_buffer_.ArrayBufferViewInput) => Int16Array;
    toInt32Array: (input: util_buffer_.ArrayBufferViewInput) => Int32Array;
    toBigInt64Array: (input: util_buffer_.ArrayBufferViewInput) => BigInt64Array;
    toUint8Array: (input: util_buffer_.ArrayBufferViewInput) => Uint8Array;
    toUint16Array: (input: util_buffer_.ArrayBufferViewInput) => Uint16Array;
    toUint32Array: (input: util_buffer_.ArrayBufferViewInput) => Uint32Array;
    toBigUint64Array: (input: util_buffer_.ArrayBufferViewInput) => BigUint64Array;
    toFloat32Array: (input: util_buffer_.ArrayBufferViewInput) => Float32Array;
    toFloat64Array: (input: util_buffer_.ArrayBufferViewInput) => Float64Array;
    toUint8ClampedArray: (input: util_buffer_.ArrayBufferViewInput) => Uint8ClampedArray;
    toInt8ArrayIterator: (input: string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | IteratorReturnResult<any> | IteratorYieldResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadValueResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadDoneResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | Iterable<util_buffer_.ArrayBufferViewInput> | null | undefined) => Generator<Int8Array, Int8Array, number | undefined>;
    toInt16ArrayIterator: (input: string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | IteratorReturnResult<any> | IteratorYieldResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadValueResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadDoneResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | Iterable<util_buffer_.ArrayBufferViewInput> | null | undefined) => Generator<Int16Array, Int16Array, number | undefined>;
    toInt32ArrayIterator: (input: string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | IteratorReturnResult<any> | IteratorYieldResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadValueResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadDoneResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | Iterable<util_buffer_.ArrayBufferViewInput> | null | undefined) => Generator<Int32Array, Int32Array, number | undefined>;
    toUint8ArrayIterator: (input: string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | IteratorReturnResult<any> | IteratorYieldResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadValueResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadDoneResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | Iterable<util_buffer_.ArrayBufferViewInput> | null | undefined) => Generator<Uint8Array, Uint8Array, number | undefined>;
    toUint16ArrayIterator: (input: string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | IteratorReturnResult<any> | IteratorYieldResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadValueResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadDoneResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | Iterable<util_buffer_.ArrayBufferViewInput> | null | undefined) => Generator<Uint16Array, Uint16Array, number | undefined>;
    toUint32ArrayIterator: (input: string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | IteratorReturnResult<any> | IteratorYieldResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadValueResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadDoneResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | Iterable<util_buffer_.ArrayBufferViewInput> | null | undefined) => Generator<Uint32Array, Uint32Array, number | undefined>;
    toFloat32ArrayIterator: (input: string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | IteratorReturnResult<any> | IteratorYieldResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadValueResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadDoneResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | Iterable<util_buffer_.ArrayBufferViewInput> | null | undefined) => Generator<Float32Array, Float32Array, number | undefined>;
    toFloat64ArrayIterator: (input: string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | IteratorReturnResult<any> | IteratorYieldResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadValueResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadDoneResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | Iterable<util_buffer_.ArrayBufferViewInput> | null | undefined) => Generator<Float64Array, Float64Array, number | undefined>;
    toUint8ClampedArrayIterator: (input: string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | IteratorReturnResult<any> | IteratorYieldResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadValueResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadDoneResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | Iterable<util_buffer_.ArrayBufferViewInput> | null | undefined) => Generator<Uint8ClampedArray, Uint8ClampedArray, number | undefined>;
    toInt8ArrayAsyncIterator: (input: string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | IteratorReturnResult<any> | IteratorYieldResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadValueResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadDoneResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | AsyncIterable<util_buffer_.ArrayBufferViewInput> | Iterable<util_buffer_.ArrayBufferViewInput> | PromiseLike<util_buffer_.ArrayBufferViewInput> | null | undefined) => AsyncGenerator<Int8Array, Int8Array, number | undefined>;
    toInt16ArrayAsyncIterator: (input: string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | IteratorReturnResult<any> | IteratorYieldResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadValueResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadDoneResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | AsyncIterable<util_buffer_.ArrayBufferViewInput> | Iterable<util_buffer_.ArrayBufferViewInput> | PromiseLike<util_buffer_.ArrayBufferViewInput> | null | undefined) => AsyncGenerator<Int16Array, Int16Array, number | undefined>;
    toInt32ArrayAsyncIterator: (input: string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | IteratorReturnResult<any> | IteratorYieldResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadValueResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadDoneResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | AsyncIterable<util_buffer_.ArrayBufferViewInput> | Iterable<util_buffer_.ArrayBufferViewInput> | PromiseLike<util_buffer_.ArrayBufferViewInput> | null | undefined) => AsyncGenerator<Int32Array, Int32Array, number | undefined>;
    toUint8ArrayAsyncIterator: (input: string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | IteratorReturnResult<any> | IteratorYieldResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadValueResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadDoneResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | AsyncIterable<util_buffer_.ArrayBufferViewInput> | Iterable<util_buffer_.ArrayBufferViewInput> | PromiseLike<util_buffer_.ArrayBufferViewInput> | null | undefined) => AsyncGenerator<Uint8Array, Uint8Array, number | undefined>;
    toUint16ArrayAsyncIterator: (input: string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | IteratorReturnResult<any> | IteratorYieldResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadValueResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadDoneResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | AsyncIterable<util_buffer_.ArrayBufferViewInput> | Iterable<util_buffer_.ArrayBufferViewInput> | PromiseLike<util_buffer_.ArrayBufferViewInput> | null | undefined) => AsyncGenerator<Uint16Array, Uint16Array, number | undefined>;
    toUint32ArrayAsyncIterator: (input: string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | IteratorReturnResult<any> | IteratorYieldResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadValueResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadDoneResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | AsyncIterable<util_buffer_.ArrayBufferViewInput> | Iterable<util_buffer_.ArrayBufferViewInput> | PromiseLike<util_buffer_.ArrayBufferViewInput> | null | undefined) => AsyncGenerator<Uint32Array, Uint32Array, number | undefined>;
    toFloat32ArrayAsyncIterator: (input: string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | IteratorReturnResult<any> | IteratorYieldResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadValueResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadDoneResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | AsyncIterable<util_buffer_.ArrayBufferViewInput> | Iterable<util_buffer_.ArrayBufferViewInput> | PromiseLike<util_buffer_.ArrayBufferViewInput> | null | undefined) => AsyncGenerator<Float32Array, Float32Array, number | undefined>;
    toFloat64ArrayAsyncIterator: (input: string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | IteratorReturnResult<any> | IteratorYieldResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadValueResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadDoneResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | AsyncIterable<util_buffer_.ArrayBufferViewInput> | Iterable<util_buffer_.ArrayBufferViewInput> | PromiseLike<util_buffer_.ArrayBufferViewInput> | null | undefined) => AsyncGenerator<Float64Array, Float64Array, number | undefined>;
    toUint8ClampedArrayAsyncIterator: (input: string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | IteratorReturnResult<any> | IteratorYieldResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadValueResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | ReadableStreamReadDoneResult<string | ArrayBuffer | SharedArrayBuffer | ArrayBufferView | ArrayLike<number> | Iterable<number> | flatbuffers.ByteBuffer | null | undefined> | AsyncIterable<util_buffer_.ArrayBufferViewInput> | Iterable<util_buffer_.ArrayBufferViewInput> | PromiseLike<util_buffer_.ArrayBufferViewInput> | null | undefined) => AsyncGenerator<Uint8ClampedArray, Uint8ClampedArray, number | undefined>;
    uint16ToFloat64(h: number): number;
    float64ToUint16(d: number): number;
    getBool(_data: any, _index: number, byte: number, bit: number): boolean;
    getBit(_data: any, _index: number, byte: number, bit: number): 0 | 1;
    setBool(bytes: Uint8Array, index: number, value: any): boolean;
    truncateBitmap(offset: number, length: number, bitmap: Uint8Array): Uint8Array;
    packBools(values: Iterable<any>): Uint8Array;
    popcnt_bit_range(data: Uint8Array, lhs: number, rhs: number): number;
    popcnt_array(arr: ArrayBufferView, byteOffset?: number | undefined, byteLength?: number | undefined): number;
    popcnt_uint32(uint32: number): number;
    BitIterator: typeof util_bit_.BitIterator;
    BaseInt64: typeof util_int_.BaseInt64;
    Uint64: typeof util_int_.Uint64;
    Int64: typeof util_int_.Int64;
    Int128: typeof util_int_.Int128;
    isArrowBigNumSymbol: typeof util_bn_.isArrowBigNumSymbol;
    bignumToString: <T_9 extends util_bn_.BN<Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array>>(a: T_9) => string;
    bignumToBigInt: <T_10 extends util_bn_.BN<Int8Array | Uint8Array | Uint8ClampedArray | Int16Array | Uint16Array | Int32Array | Uint32Array>>(a: T_10) => bigint;
    BN: typeof util_bn_.BN;
};
export { isTypedArray } from './util/args';
