import { Field } from '../schema';
import { Column } from '../column';
import { Vector } from '../vector';
import { DataType, Float32, Float64, Int16, Int32, Int64, Int8, Uint16, Uint32, Uint64, Uint8 } from '../type';
import { BigIntArray, TypedArray as TypedArray_ } from '../interfaces';
import { FloatArrayCtor } from '../vector/float';
import { IntArrayCtor } from '../vector/int';
declare type RecordBatchCtor = typeof import('../recordbatch').RecordBatch;
declare type TypedArray = Exclude<TypedArray_ | BigIntArray, Uint8ClampedArray>;
/** @ignore */
export declare function isTypedArray(arr: any): arr is TypedArray;
/** @ignore */
declare type ArrayCtor = FloatArrayCtor | IntArrayCtor;
/** @ignore */
export declare function arrayTypeToDataType(ctor: ArrayCtor): typeof Int8 | typeof Int16 | typeof Int32 | typeof Int64 | typeof Uint8 | typeof Uint16 | typeof Uint32 | typeof Uint64 | typeof Float32 | typeof Float64 | null;
/** @ignore */
export declare const selectArgs: <T>(Ctor: any, vals: any[]) => T[];
/** @ignore */
export declare const selectColumnArgs: <T extends {
    [key: string]: DataType<import("../enum").Type, any>;
}>(args: any[]) => Column<any>[];
/** @ignore */
export declare const selectFieldArgs: <T extends {
    [key: string]: DataType<import("../enum").Type, any>;
}>(args: any[]) => [Field<T[keyof T]>[], (Int8Array | Uint8Array | Int16Array | Uint16Array | Int32Array | Uint32Array | Float32Array | Float64Array | BigInt64Array | BigUint64Array | T[keyof T] | Vector<T[keyof T]>)[]];
/** @ignore */
export declare const selectChunkArgs: <T>(Ctor: any, vals: any[]) => T[];
/** @ignore */
export declare const selectVectorChildrenArgs: <T extends Vector<any>>(Ctor: RecordBatchCtor, vals: any[]) => T[];
/** @ignore */
export declare const selectColumnChildrenArgs: <T extends Column<any>>(Ctor: RecordBatchCtor, vals: any[]) => T[];
export {};
