"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CaseInsensitiveInputStream = void 0;
/*
 [The "BSD licence"]
 Copyright (c) 2019 Kevin Jones
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:
 1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
 2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.
 3. The name of the author may not be used to endorse or promote products
    derived from this software without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
const antlr4ts_1 = require("antlr4ts");
class CaseInsensitiveInputStream extends antlr4ts_1.ANTLRInputStream {
    // userData is an untyped identifier of where the stream is from
    constructor(userData, input) {
        super(input);
        this.userData = userData;
    }
    LA(i) {
        return this.toLower(super.LA(i));
    }
    // We only need basic upper to lower conversions
    toLower(c) {
        if (c >= 65 && c <= 90) {
            return c + 32;
        }
        else {
            return c;
        }
    }
}
exports.CaseInsensitiveInputStream = CaseInsensitiveInputStream;
//# sourceMappingURL=CaseInsensitiveInputStream.js.map