"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ApexLexer_1 = require("../ApexLexer");
const CaseInsensitiveInputStream_1 = require("../CaseInsensitiveInputStream");
const antlr4ts_1 = require("antlr4ts");
test('Lexer generates tokens', () => {
    let lexer = new ApexLexer_1.ApexLexer(new antlr4ts_1.ANTLRInputStream("public class Hello {}"));
    let tokens = new antlr4ts_1.CommonTokenStream(lexer);
    expect(tokens.getNumberOfOnChannelTokens()).toBe(6);
});
test('Case insensitivity', () => {
    let lexer = new ApexLexer_1.ApexLexer(new CaseInsensitiveInputStream_1.CaseInsensitiveInputStream("test.cls", "public"));
    let tokens = new antlr4ts_1.CommonTokenStream(lexer);
    expect(tokens.getNumberOfOnChannelTokens()).toBe(2);
});
test('Case insensitivity (upper case)', () => {
    let lexer = new ApexLexer_1.ApexLexer(new CaseInsensitiveInputStream_1.CaseInsensitiveInputStream("test.cls", "PUBLIC"));
    let tokens = new antlr4ts_1.CommonTokenStream(lexer);
    expect(tokens.getNumberOfOnChannelTokens()).toBe(2);
});
test('Case insensitivity (mixed case)', () => {
    let lexer = new ApexLexer_1.ApexLexer(new CaseInsensitiveInputStream_1.CaseInsensitiveInputStream("test.cls", "PuBliC"));
    let tokens = new antlr4ts_1.CommonTokenStream(lexer);
    expect(tokens.getNumberOfOnChannelTokens()).toBe(2);
});
//# sourceMappingURL=ApexLexerTest.js.map