"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ApexLexer_1 = require("../ApexLexer");
const ApexParser_1 = require("../ApexParser");
const CaseInsensitiveInputStream_1 = require("../CaseInsensitiveInputStream");
const antlr4ts_1 = require("antlr4ts");
const ParseTreeWalker_1 = require("antlr4ts/tree/ParseTreeWalker");
const ThrowingErrorListener_1 = require("../ThrowingErrorListener");
class TestListener {
    constructor() {
        this.methodCount = 0;
    }
    enterMethodDeclaration(ctx) {
        this.methodCount += 1;
    }
}
test('Listener Generates Events', () => {
    let lexer = new ApexLexer_1.ApexLexer(new CaseInsensitiveInputStream_1.CaseInsensitiveInputStream("test.cls", "public class Hello {}"));
    let tokens = new antlr4ts_1.CommonTokenStream(lexer);
    let parser = new ApexParser_1.ApexParser(tokens);
    parser.removeErrorListeners();
    parser.addErrorListener(new ThrowingErrorListener_1.ThrowingErrorListener());
    const cu = parser.compilationUnit();
    const listener = new TestListener();
    ParseTreeWalker_1.ParseTreeWalker.DEFAULT.walk(listener, cu);
    expect(listener.methodCount == 1);
});
//# sourceMappingURL=ApexListenerTest.js.map