"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ApexLexer_1 = require("../ApexLexer");
const ApexParser_1 = require("../ApexParser");
const CaseInsensitiveInputStream_1 = require("../CaseInsensitiveInputStream");
const antlr4ts_1 = require("antlr4ts");
const ThrowingErrorListener_1 = require("../ThrowingErrorListener");
test('Boolean Literal', () => {
    let lexer = new ApexLexer_1.ApexLexer(new CaseInsensitiveInputStream_1.CaseInsensitiveInputStream("test.cls", "true"));
    let tokens = new antlr4ts_1.CommonTokenStream(lexer);
    let parser = new ApexParser_1.ApexParser(tokens);
    let context = parser.literal();
    expect(context).toBeInstanceOf(ApexParser_1.LiteralContext);
    expect(context.BooleanLiteral()).toBeTruthy();
    expect(context.BooleanLiteral().text).toBe("true");
});
test('Expression', () => {
    let lexer = new ApexLexer_1.ApexLexer(new CaseInsensitiveInputStream_1.CaseInsensitiveInputStream("test.cls", "a * 5"));
    let tokens = new antlr4ts_1.CommonTokenStream(lexer);
    let parser = new ApexParser_1.ApexParser(tokens);
    let context = parser.expression();
    expect(context).toBeInstanceOf(ApexParser_1.Arth1ExpressionContext);
    let arthExpression = context;
    expect(arthExpression.expression().length).toBe(2);
});
test('Compilation Unit', () => {
    let lexer = new ApexLexer_1.ApexLexer(new CaseInsensitiveInputStream_1.CaseInsensitiveInputStream("test.cls", "public class Hello {}"));
    let tokens = new antlr4ts_1.CommonTokenStream(lexer);
    let parser = new ApexParser_1.ApexParser(tokens);
    let context = parser.compilationUnit();
    expect(context.typeDeclaration).toBeTruthy();
});
test('Compilation Unit (throwing errors)', () => {
    let lexer = new ApexLexer_1.ApexLexer(new CaseInsensitiveInputStream_1.CaseInsensitiveInputStream("test.cls", "public class Hello {"));
    let tokens = new antlr4ts_1.CommonTokenStream(lexer);
    let parser = new ApexParser_1.ApexParser(tokens);
    parser.removeErrorListeners();
    parser.addErrorListener(new ThrowingErrorListener_1.ThrowingErrorListener());
    try {
        parser.compilationUnit();
        expect(true).toBe(false);
    }
    catch (ex) {
        expect(ex).toBeInstanceOf(ThrowingErrorListener_1.SyntaxException);
    }
});
test('Trigger Unit', () => {
    let lexer = new ApexLexer_1.ApexLexer(new CaseInsensitiveInputStream_1.CaseInsensitiveInputStream("test.trigger", "trigger test on Account (before update, after update) {}"));
    let tokens = new antlr4ts_1.CommonTokenStream(lexer);
    let parser = new ApexParser_1.ApexParser(tokens);
    let context = parser.triggerUnit();
    expect(context).toBeTruthy();
});
//# sourceMappingURL=ApexParserTest.js.map