"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ApexLexer_1 = require("../ApexLexer");
const ApexParser_1 = require("../ApexParser");
const CaseInsensitiveInputStream_1 = require("../CaseInsensitiveInputStream");
const antlr4ts_1 = require("antlr4ts");
const AbstractParseTreeVisitor_1 = require("antlr4ts/tree/AbstractParseTreeVisitor");
const ThrowingErrorListener_1 = require("../ThrowingErrorListener");
class TestVisitor extends AbstractParseTreeVisitor_1.AbstractParseTreeVisitor {
    constructor() {
        super(...arguments);
        this.methodCount = 0;
    }
    visitMethodDeclaration(ctx) {
        this.methodCount += 1;
        return 1 + super.visitChildren(ctx);
    }
    defaultResult() {
        return 0;
    }
}
test('Vistor is visited', () => {
    let lexer = new ApexLexer_1.ApexLexer(new CaseInsensitiveInputStream_1.CaseInsensitiveInputStream("test.cls", "public class Hello {}"));
    let tokens = new antlr4ts_1.CommonTokenStream(lexer);
    let parser = new ApexParser_1.ApexParser(tokens);
    parser.removeErrorListeners();
    parser.addErrorListener(new ThrowingErrorListener_1.ThrowingErrorListener());
    const cu = parser.compilationUnit();
    const visitor = new TestVisitor();
    visitor.visit(cu);
    expect(visitor.methodCount == 1);
});
//# sourceMappingURL=ApexVisitorTest.js.map