/// <reference types="typed-graphql" />
/// <reference types="node" />
/// <reference types="chai" />
import { NetworkInterface } from './networkInterface';
import { ApolloStore, Store } from './store';
import { QueryStoreValue } from './queries/store';
import { QueryTransformer } from './queries/queryTransform';
import { NormalizedCache } from './data/store';
import { Document, FragmentDefinition, SelectionSet } from 'graphql';
import { MutationBehavior, MutationQueryReducersMap } from './data/mutationResults';
import { QueryScheduler } from './scheduler';
import { ApolloQueryResult, ApolloStateSelector } from './index';
import { Observer, Subscription, Observable } from './util/Observable';
import { WatchQueryOptions } from './watchQueryOptions';
import { ObservableQuery } from './ObservableQuery';
export declare type QueryListener = (queryStoreValue: QueryStoreValue) => void;
export interface SubscriptionOptions {
    query: Document;
    variables?: {
        [key: string]: any;
    };
    fragments?: FragmentDefinition[];
}
export declare type ResultTransformer = (resultData: ApolloQueryResult) => ApolloQueryResult;
export declare type ResultComparator = (result1: ApolloQueryResult, result2: ApolloQueryResult) => boolean;
export declare class QueryManager {
    pollingTimers: {
        [queryId: string]: NodeJS.Timer | any;
    };
    scheduler: QueryScheduler;
    store: ApolloStore;
    private networkInterface;
    private reduxRootSelector;
    private queryTransformer;
    private resultTransformer;
    private resultComparator;
    private queryListeners;
    private idCounter;
    private batcher;
    private batchInterval;
    private fetchQueryPromises;
    private observableQueries;
    private queryIdsByName;
    constructor({networkInterface, store, reduxRootSelector, queryTransformer, resultTransformer, resultComparator, shouldBatch, batchInterval}: {
        networkInterface: NetworkInterface;
        store: ApolloStore;
        reduxRootSelector: ApolloStateSelector;
        queryTransformer?: QueryTransformer;
        resultTransformer?: ResultTransformer;
        resultComparator?: ResultComparator;
        shouldBatch?: Boolean;
        batchInterval?: number;
    });
    broadcastNewStore(store: any): void;
    mutate({mutation, variables, resultBehaviors, fragments, optimisticResponse, updateQueries, refetchQueries}: {
        mutation: Document;
        variables?: Object;
        resultBehaviors?: MutationBehavior[];
        fragments?: FragmentDefinition[];
        optimisticResponse?: Object;
        updateQueries?: MutationQueryReducersMap;
        refetchQueries?: string[];
    }): Promise<ApolloQueryResult>;
    queryListenerForObserver(queryId: string, options: WatchQueryOptions, observer: Observer<ApolloQueryResult>): QueryListener;
    watchQuery(options: WatchQueryOptions, shouldSubscribe?: boolean): ObservableQuery;
    query(options: WatchQueryOptions): Promise<ApolloQueryResult>;
    fetchQuery(queryId: string, options: WatchQueryOptions): Promise<ApolloQueryResult>;
    generateQueryId(): string;
    stopQueryInStore(queryId: string): void;
    getApolloState(): Store;
    getDataWithOptimisticResults(): NormalizedCache;
    addQueryListener(queryId: string, listener: QueryListener): void;
    addFetchQueryPromise(requestId: number, promise: Promise<ApolloQueryResult>, resolve: (result: ApolloQueryResult) => void, reject: (error: Error) => void): void;
    removeFetchQueryPromise(requestId: number): void;
    addObservableQuery(queryId: string, observableQuery: ObservableQuery): void;
    addQuerySubscription(queryId: string, querySubscription: Subscription): void;
    removeObservableQuery(queryId: string): void;
    resetStore(): void;
    startQuery(queryId: string, options: WatchQueryOptions, listener: QueryListener): string;
    startGraphQLSubscription(options: SubscriptionOptions): Observable<any>;
    stopQuery(queryId: string): void;
    getCurrentQueryResult(observableQuery: ObservableQuery, isOptimistic?: boolean): {
        data: Object;
        partial: boolean;
    };
    getQueryWithPreviousResult(queryIdOrObservable: string | ObservableQuery, isOptimistic?: boolean): {
        previousResult: Object;
        queryVariables: {
            [key: string]: any;
        };
        querySelectionSet: SelectionSet;
        queryFragments: FragmentDefinition[];
    };
    transformResult(result: ApolloQueryResult): ApolloQueryResult;
    private getQueryParts(observableQuery);
    private collectResultBehaviorsFromUpdateQueries(updateQueries, mutationResult, isOptimistic?);
    private transformQueryDocument(options);
    private handleDiffQuery({queryDef, rootId, variables, fragmentMap, noFetch});
    private fetchRequest({requestId, queryId, query, querySS, options, fragmentMap});
    private fetchQueryOverInterface(queryId, options);
    private refetchQueryByName(queryName);
    private isDifferentResult(lastResult, newResult);
    private broadcastQueries();
    private generateRequestId();
}
