"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var networkInterface_1 = require('./networkInterface');
require('whatwg-fetch');
var assign = require('lodash.assign');
var HTTPBatchedNetworkInterface = (function (_super) {
    __extends(HTTPBatchedNetworkInterface, _super);
    function HTTPBatchedNetworkInterface(uri, opts) {
        _super.call(this, uri, opts);
    }
    ;
    HTTPBatchedNetworkInterface.prototype.batchedFetchFromRemoteEndpoint = function (requestsAndOptions) {
        var options = {};
        requestsAndOptions.forEach(function (requestAndOptions) {
            assign(options, requestAndOptions.options);
        });
        var printedRequests = requestsAndOptions.map(function (_a) {
            var request = _a.request;
            return networkInterface_1.printRequest(request);
        });
        return fetch(this._uri, assign({}, this._opts, options, {
            body: JSON.stringify(printedRequests),
            headers: assign({}, options.headers, {
                Accept: '*/*',
                'Content-Type': 'application/json',
            }),
            method: 'POST',
        }));
    };
    ;
    HTTPBatchedNetworkInterface.prototype.batchQuery = function (requests) {
        var _this = this;
        var options = assign({}, this._opts);
        var middlewarePromises = [];
        requests.forEach(function (request) {
            middlewarePromises.push(_this.applyMiddlewares({
                request: request,
                options: options,
            }));
        });
        return new Promise(function (resolve, reject) {
            Promise.all(middlewarePromises).then(function (requestsAndOptions) {
                return _this.batchedFetchFromRemoteEndpoint(requestsAndOptions)
                    .then(function (result) {
                    return result.json();
                })
                    .then(function (responses) {
                    var afterwaresPromises = responses.map(function (response, index) {
                        return _this.applyAfterwares({
                            response: response,
                            options: requestsAndOptions[index].options,
                        });
                    });
                    Promise.all(afterwaresPromises).then(function (responsesAndOptions) {
                        var results = [];
                        responsesAndOptions.forEach(function (_a) {
                            var response = _a.response;
                            results.push(response);
                        });
                        resolve(results);
                    }).catch(function (error) {
                        reject(error);
                    });
                });
            }).catch(function (error) {
                reject(error);
            });
        });
    };
    return HTTPBatchedNetworkInterface;
}(networkInterface_1.HTTPFetchNetworkInterface));
exports.HTTPBatchedNetworkInterface = HTTPBatchedNetworkInterface;
//# sourceMappingURL=batchedNetworkInterface.js.map