/// <reference types="typed-graphql" />
/// <reference types="chai" />
/// <reference types="node" />
import { NormalizedCache } from './store';
import { SelectionSetWithRoot } from '../queries/store';
import { SelectionSet, Document } from 'graphql';
import { FragmentMap } from '../queries/getFromAST';
export interface DiffResult {
    result: any;
    isMissing?: 'true';
    missingSelectionSets?: SelectionSetWithRoot[];
}
export declare function diffQueryAgainstStore({store, query, variables}: {
    store: NormalizedCache;
    query: Document;
    variables?: Object;
}): DiffResult;
export declare function diffFragmentAgainstStore({store, fragment, rootId, variables}: {
    store: NormalizedCache;
    fragment: Document;
    rootId: string;
    variables?: Object;
}): DiffResult;
export declare function handleFragmentErrors(fragmentErrors: {
    [typename: string]: Error;
}): void;
export declare function diffSelectionSetAgainstStore({selectionSet, store, rootId, throwOnMissingField, variables, fragmentMap}: {
    selectionSet: SelectionSet;
    store: NormalizedCache;
    rootId: string;
    throwOnMissingField: boolean;
    variables: Object;
    fragmentMap?: FragmentMap;
}): DiffResult;
export declare function removeUnusedVariablesFromQuery(query: Document): void;
