/// <reference types="typed-graphql" />
/// <reference types="chai" />
import { SelectionSet, Document } from 'graphql';
import { FragmentMap } from '../queries/getFromAST';
import { NormalizedCache } from './store';
export declare function readQueryFromStore({store, query, variables, returnPartialData, fragmentMap}: {
    store: NormalizedCache;
    query: Document;
    variables?: Object;
    returnPartialData?: boolean;
    fragmentMap?: FragmentMap;
}): Object;
export declare function readFragmentFromStore({store, fragment, rootId, variables, returnPartialData}: {
    store: NormalizedCache;
    fragment: Document;
    rootId: string;
    variables?: Object;
    returnPartialData?: boolean;
}): Object;
export declare function readSelectionSetFromStore({store, rootId, selectionSet, variables, returnPartialData, fragmentMap}: {
    store: NormalizedCache;
    rootId: string;
    selectionSet: SelectionSet;
    variables: Object;
    returnPartialData?: boolean;
    fragmentMap?: FragmentMap;
}): Object;
