/// <reference types="typed-graphql" />
/// <reference types="chai" />
import { NetworkInterface, createNetworkInterface, addQueryMerging } from './networkInterface';
import { Document, FragmentDefinition } from 'graphql';
import { print } from 'graphql-tag/printer';
import { createApolloStore, ApolloStore, createApolloReducer, ApolloReducerConfig, Store } from './store';
import { QueryManager, SubscriptionOptions, ResultComparator, ResultTransformer } from './QueryManager';
import { ObservableQuery } from './ObservableQuery';
import { Observable, Subscription } from './util/Observable';
import { WatchQueryOptions } from './watchQueryOptions';
import { readQueryFromStore, readFragmentFromStore } from './data/readFromStore';
import { writeQueryToStore, writeFragmentToStore } from './data/writeToStore';
import { IdGetter } from './data/extensions';
import { QueryTransformer, addTypenameToSelectionSet } from './queries/queryTransform';
import { MutationBehavior, MutationBehaviorReducerMap, MutationQueryReducersMap } from './data/mutationResults';
import { createFragmentMap } from './queries/getFromAST';
import { ApolloError } from './errors';
export { createNetworkInterface, addQueryMerging, createApolloStore, createApolloReducer, readQueryFromStore, readFragmentFromStore, addTypenameToSelectionSet as addTypename, writeQueryToStore, writeFragmentToStore, print as printAST, createFragmentMap, ApolloError, WatchQueryOptions, ObservableQuery, MutationBehavior, MutationQueryReducersMap, Subscription, ApolloStore };
export declare type ApolloQueryResult = {
    data: any;
    loading: boolean;
};
export declare type ApolloStateSelector = (state: any) => Store;
export declare let fragmentDefinitionsMap: {
    [fragmentName: string]: FragmentDefinition[];
};
export declare function createFragment(doc: Document, fragments?: (FragmentDefinition[] | FragmentDefinition[][])): FragmentDefinition[];
export declare function disableFragmentWarnings(): void;
export declare function enableFragmentWarnings(): void;
export declare function clearFragmentDefinitions(): void;
export default class ApolloClient {
    networkInterface: NetworkInterface;
    store: ApolloStore;
    reduxRootKey: string;
    reduxRootSelector: ApolloStateSelector | null;
    initialState: any;
    queryManager: QueryManager;
    reducerConfig: ApolloReducerConfig;
    queryTransformer: QueryTransformer;
    resultTransformer: ResultTransformer;
    resultComparator: ResultComparator;
    shouldBatch: boolean;
    shouldForceFetch: boolean;
    dataId: IdGetter;
    fieldWithArgs: (fieldName: string, args?: Object) => string;
    batchInterval: number;
    constructor({networkInterface, reduxRootKey, reduxRootSelector, initialState, dataIdFromObject, queryTransformer, resultTransformer, resultComparator, shouldBatch, ssrMode, ssrForceFetchDelay, mutationBehaviorReducers, batchInterval}?: {
        networkInterface?: NetworkInterface;
        reduxRootKey?: string;
        reduxRootSelector?: string | ApolloStateSelector;
        initialState?: any;
        dataIdFromObject?: IdGetter;
        queryTransformer?: QueryTransformer;
        resultTransformer?: ResultTransformer;
        resultComparator?: ResultComparator;
        shouldBatch?: boolean;
        ssrMode?: boolean;
        ssrForceFetchDelay?: number;
        mutationBehaviorReducers?: MutationBehaviorReducerMap;
        batchInterval?: number;
    });
    watchQuery(options: WatchQueryOptions): ObservableQuery;
    query(options: WatchQueryOptions): Promise<ApolloQueryResult>;
    mutate(options: {
        mutation: Document;
        variables?: Object;
        resultBehaviors?: MutationBehavior[];
        fragments?: FragmentDefinition[];
        optimisticResponse?: Object;
        updateQueries?: MutationQueryReducersMap;
        refetchQueries?: string[];
    }): Promise<ApolloQueryResult>;
    subscribe(options: SubscriptionOptions): Observable<any>;
    reducer(): Function;
    middleware: () => (store: ApolloStore) => (next: any) => (action: any) => any;
    initStore(): void;
    resetStore(): void;
    private setStore(store);
}
