"use strict";
var networkInterface_1 = require('./networkInterface');
exports.createNetworkInterface = networkInterface_1.createNetworkInterface;
exports.addQueryMerging = networkInterface_1.addQueryMerging;
var printer_1 = require('graphql-tag/printer');
exports.printAST = printer_1.print;
var store_1 = require('./store');
exports.createApolloStore = store_1.createApolloStore;
exports.createApolloReducer = store_1.createApolloReducer;
var QueryManager_1 = require('./QueryManager');
var ObservableQuery_1 = require('./ObservableQuery');
exports.ObservableQuery = ObservableQuery_1.ObservableQuery;
var readFromStore_1 = require('./data/readFromStore');
exports.readQueryFromStore = readFromStore_1.readQueryFromStore;
exports.readFragmentFromStore = readFromStore_1.readFragmentFromStore;
var writeToStore_1 = require('./data/writeToStore');
exports.writeQueryToStore = writeToStore_1.writeQueryToStore;
exports.writeFragmentToStore = writeToStore_1.writeFragmentToStore;
var queryTransform_1 = require('./queries/queryTransform');
exports.addTypename = queryTransform_1.addTypenameToSelectionSet;
var storeUtils_1 = require('./data/storeUtils');
var getFromAST_1 = require('./queries/getFromAST');
exports.createFragmentMap = getFromAST_1.createFragmentMap;
var errors_1 = require('./errors');
exports.ApolloError = errors_1.ApolloError;
var isUndefined = require('lodash.isundefined');
var assign = require('lodash.assign');
var flatten = require('lodash.flatten');
var isString = require('lodash.isstring');
var DEFAULT_REDUX_ROOT_KEY = 'apollo';
exports.fragmentDefinitionsMap = {};
var printFragmentWarnings = true;
function createFragment(doc, fragments) {
    if (fragments === void 0) { fragments = []; }
    fragments = flatten(fragments);
    var fragmentDefinitions = getFromAST_1.getFragmentDefinitions(doc);
    fragmentDefinitions.forEach(function (fragmentDefinition) {
        var fragmentName = fragmentDefinition.name.value;
        if (exports.fragmentDefinitionsMap.hasOwnProperty(fragmentName) &&
            exports.fragmentDefinitionsMap[fragmentName].indexOf(fragmentDefinition) === -1) {
            if (printFragmentWarnings) {
                console.warn("Warning: fragment with name " + fragmentDefinition.name.value + " already exists.\nApollo Client enforces all fragment names across your application to be unique; read more about\nthis in the docs: http://docs.apollostack.com/");
            }
            exports.fragmentDefinitionsMap[fragmentName].push(fragmentDefinition);
        }
        else if (!exports.fragmentDefinitionsMap.hasOwnProperty(fragmentName)) {
            exports.fragmentDefinitionsMap[fragmentName] = [fragmentDefinition];
        }
    });
    return fragments.concat(fragmentDefinitions);
}
exports.createFragment = createFragment;
function disableFragmentWarnings() {
    printFragmentWarnings = false;
}
exports.disableFragmentWarnings = disableFragmentWarnings;
function enableFragmentWarnings() {
    printFragmentWarnings = true;
}
exports.enableFragmentWarnings = enableFragmentWarnings;
function clearFragmentDefinitions() {
    exports.fragmentDefinitionsMap = {};
}
exports.clearFragmentDefinitions = clearFragmentDefinitions;
function defaultReduxRootSelector(state) {
    return state[DEFAULT_REDUX_ROOT_KEY];
}
var ApolloClient = (function () {
    function ApolloClient(_a) {
        var _this = this;
        var _b = _a === void 0 ? {} : _a, networkInterface = _b.networkInterface, reduxRootKey = _b.reduxRootKey, reduxRootSelector = _b.reduxRootSelector, initialState = _b.initialState, dataIdFromObject = _b.dataIdFromObject, queryTransformer = _b.queryTransformer, resultTransformer = _b.resultTransformer, resultComparator = _b.resultComparator, _c = _b.shouldBatch, shouldBatch = _c === void 0 ? false : _c, _d = _b.ssrMode, ssrMode = _d === void 0 ? false : _d, _e = _b.ssrForceFetchDelay, ssrForceFetchDelay = _e === void 0 ? 0 : _e, _f = _b.mutationBehaviorReducers, mutationBehaviorReducers = _f === void 0 ? {} : _f, batchInterval = _b.batchInterval;
        this.middleware = function () {
            return function (store) {
                _this.setStore(store);
                return function (next) { return function (action) {
                    var returnValue = next(action);
                    _this.queryManager.broadcastNewStore(store.getState());
                    return returnValue;
                }; };
            };
        };
        if (reduxRootKey && reduxRootSelector) {
            throw new Error('Both "reduxRootKey" and "reduxRootSelector" are configured, but only one of two is allowed.');
        }
        if (reduxRootKey) {
            console.warn('"reduxRootKey" option is deprecated and might be removed in the upcoming versions, ' +
                'please use the "reduxRootSelector" instead.');
            this.reduxRootKey = reduxRootKey;
        }
        if (!reduxRootSelector && reduxRootKey) {
            this.reduxRootSelector = function (state) { return state[reduxRootKey]; };
        }
        else if (isString(reduxRootSelector)) {
            this.reduxRootKey = reduxRootSelector;
            this.reduxRootSelector = function (state) { return state[reduxRootSelector]; };
        }
        else if (typeof reduxRootSelector === 'function') {
            this.reduxRootSelector = reduxRootSelector;
        }
        else {
            this.reduxRootSelector = null;
        }
        this.initialState = initialState ? initialState : {};
        this.networkInterface = networkInterface ? networkInterface :
            networkInterface_1.createNetworkInterface('/graphql');
        this.queryTransformer = queryTransformer;
        this.resultTransformer = resultTransformer;
        this.resultComparator = resultComparator;
        this.shouldBatch = shouldBatch;
        this.shouldForceFetch = !(ssrMode || ssrForceFetchDelay > 0);
        this.dataId = dataIdFromObject;
        this.fieldWithArgs = storeUtils_1.storeKeyNameFromFieldNameAndArgs;
        this.batchInterval = batchInterval;
        if (ssrForceFetchDelay) {
            setTimeout(function () { return _this.shouldForceFetch = true; }, ssrForceFetchDelay);
        }
        this.reducerConfig = {
            dataIdFromObject: dataIdFromObject,
            mutationBehaviorReducers: mutationBehaviorReducers,
        };
        this.watchQuery = this.watchQuery.bind(this);
        this.query = this.query.bind(this);
        this.mutate = this.mutate.bind(this);
        this.setStore = this.setStore.bind(this);
    }
    ApolloClient.prototype.watchQuery = function (options) {
        this.initStore();
        if (!this.shouldForceFetch && options.forceFetch) {
            options = assign({}, options, {
                forceFetch: false,
            });
        }
        createFragment(options.query);
        return this.queryManager.watchQuery(options);
    };
    ;
    ApolloClient.prototype.query = function (options) {
        this.initStore();
        if (!this.shouldForceFetch && options.forceFetch) {
            options = assign({}, options, {
                forceFetch: false,
            });
        }
        createFragment(options.query);
        return this.queryManager.query(options);
    };
    ;
    ApolloClient.prototype.mutate = function (options) {
        this.initStore();
        return this.queryManager.mutate(options);
    };
    ;
    ApolloClient.prototype.subscribe = function (options) {
        this.initStore();
        return this.queryManager.startGraphQLSubscription(options);
    };
    ApolloClient.prototype.reducer = function () {
        return store_1.createApolloReducer(this.reducerConfig);
    };
    ApolloClient.prototype.initStore = function () {
        if (this.store) {
            return;
        }
        if (this.reduxRootSelector) {
            throw new Error('Cannot initialize the store because "reduxRootSelector" or "reduxRootKey" is provided. ' +
                'They should only be used when the store is created outside of the client. ' +
                'This may lead to unexpected results when querying the store internally. ' +
                "Please remove that option from ApolloClient constructor.");
        }
        this.setStore(store_1.createApolloStore({
            reduxRootKey: DEFAULT_REDUX_ROOT_KEY,
            initialState: this.initialState,
            config: this.reducerConfig,
        }));
        this.reduxRootKey = DEFAULT_REDUX_ROOT_KEY;
    };
    ;
    ApolloClient.prototype.resetStore = function () {
        this.queryManager.resetStore();
    };
    ;
    ApolloClient.prototype.setStore = function (store) {
        var reduxRootSelector;
        if (this.reduxRootSelector) {
            reduxRootSelector = this.reduxRootSelector;
        }
        else {
            reduxRootSelector = defaultReduxRootSelector;
            this.reduxRootKey = DEFAULT_REDUX_ROOT_KEY;
        }
        if (isUndefined(reduxRootSelector(store.getState()))) {
            throw new Error('Existing store does not use apolloReducer. Please make sure the store ' +
                'is properly configured and "reduxRootSelector" is correctly specified.');
        }
        this.store = store;
        this.queryManager = new QueryManager_1.QueryManager({
            networkInterface: this.networkInterface,
            reduxRootSelector: reduxRootSelector,
            store: store,
            queryTransformer: this.queryTransformer,
            resultTransformer: this.resultTransformer,
            resultComparator: this.resultComparator,
            shouldBatch: this.shouldBatch,
            batchInterval: this.batchInterval,
        });
    };
    ;
    return ApolloClient;
}());
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = ApolloClient;
//# sourceMappingURL=index.js.map