/// <reference types="typed-graphql" />
/// <reference types="chai" />
/// <reference types="isomorphic-fetch" />
import 'whatwg-fetch';
import { GraphQLResult, Document } from 'graphql';
import { MiddlewareInterface } from './middleware';
import { AfterwareInterface } from './afterware';
export interface Request {
    debugName?: string;
    query?: Document;
    variables?: Object;
    operationName?: string;
    [additionalKey: string]: any;
}
export interface PrintedRequest {
    debugName?: string;
    query?: string;
    variables?: Object;
    operationName?: string;
}
export interface NetworkInterface {
    [others: string]: any;
    query(request: Request): Promise<GraphQLResult>;
}
export interface SubscriptionNetworkInterface extends NetworkInterface {
    subscribe(request: Request, handler: (error: any, result: any) => void): number;
    unsubscribe(id: Number): void;
}
export interface BatchedNetworkInterface extends NetworkInterface {
    batchQuery(requests: Request[]): Promise<GraphQLResult[]>;
}
export interface HTTPNetworkInterface extends BatchedNetworkInterface {
    _uri: string;
    _opts: RequestInit;
    _middlewares: MiddlewareInterface[];
    _afterwares: AfterwareInterface[];
    use(middlewares: MiddlewareInterface[]): any;
    useAfter(afterwares: AfterwareInterface[]): any;
}
export interface RequestAndOptions {
    request: Request;
    options: RequestInit;
}
export interface ResponseAndOptions {
    response: IResponse;
    options: RequestInit;
}
export declare function addQueryMerging(networkInterface: NetworkInterface): BatchedNetworkInterface;
export declare function printRequest(request: Request): PrintedRequest;
export declare class HTTPFetchNetworkInterface implements NetworkInterface {
    _uri: string;
    _opts: RequestInit;
    _middlewares: MiddlewareInterface[];
    _afterwares: AfterwareInterface[];
    constructor(uri: string, opts?: RequestInit);
    applyMiddlewares({request, options}: RequestAndOptions): Promise<RequestAndOptions>;
    applyAfterwares({response, options}: ResponseAndOptions): Promise<ResponseAndOptions>;
    fetchFromRemoteEndpoint({request, options}: RequestAndOptions): Promise<IResponse>;
    query(request: Request): Promise<GraphQLResult>;
    use(middlewares: MiddlewareInterface[]): void;
    useAfter(afterwares: AfterwareInterface[]): void;
}
export interface NetworkInterfaceOptions {
    uri: string;
    opts?: RequestInit;
    transportBatching?: boolean;
}
export declare function createNetworkInterface(interfaceOpts: (NetworkInterfaceOptions | string), backOpts?: RequestInit): HTTPNetworkInterface;
