/// <reference types="graphql" />
import { DocumentNode } from 'graphql';
import { ApolloStore, Store } from '../store';
import { DataWrite } from '../actions';
import { IdGetter } from '../core/types';
import { NormalizedCache } from '../data/storeUtils';
export interface DataProxyReadQueryOptions {
    query: DocumentNode;
    variables?: Object;
}
export interface DataProxyReadFragmentOptions {
    id: string;
    fragment: DocumentNode;
    fragmentName?: string;
    variables?: Object;
}
export interface DataProxyWriteQueryOptions {
    data: any;
    query: DocumentNode;
    variables?: Object;
}
export interface DataProxyWriteFragmentOptions {
    data: any;
    id: string;
    fragment: DocumentNode;
    fragmentName?: string;
    variables?: Object;
}
export interface DataProxy {
    readQuery<QueryType>(options: DataProxyReadQueryOptions): QueryType;
    readFragment<FragmentType>(options: DataProxyReadFragmentOptions): FragmentType | null;
    writeQuery(options: DataProxyWriteQueryOptions): void;
    writeFragment(options: DataProxyWriteFragmentOptions): void;
}
export declare class ReduxDataProxy implements DataProxy {
    private store;
    private reduxRootSelector;
    constructor(store: ApolloStore, reduxRootSelector: (state: any) => Store);
    readQuery<QueryType>({query, variables}: DataProxyReadQueryOptions): QueryType;
    readFragment<FragmentType>({id, fragment, fragmentName, variables}: DataProxyReadFragmentOptions): FragmentType | null;
    writeQuery({data, query, variables}: DataProxyWriteQueryOptions): void;
    writeFragment({data, id, fragment, fragmentName, variables}: DataProxyWriteFragmentOptions): void;
}
export declare class TransactionDataProxy implements DataProxy {
    private data;
    private dataIdFromObject;
    private writes;
    private isFinished;
    constructor(data: NormalizedCache, dataIdFromObject?: IdGetter);
    finish(): Array<DataWrite>;
    readQuery<QueryType>({query, variables}: DataProxyReadQueryOptions): QueryType;
    readFragment<FragmentType>({id, fragment, fragmentName, variables}: DataProxyReadFragmentOptions): FragmentType | null;
    writeQuery({data, query, variables}: DataProxyWriteQueryOptions): void;
    writeFragment({data, id, fragment, fragmentName, variables}: DataProxyWriteFragmentOptions): void;
    private assertNotFinished();
    private applyWrite(write);
}
